/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerTypeNameSpec;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.List;
import java.util.function.Consumer;

public final class HazelcastTypeCoercion
extends TypeCoercionImpl {
    public HazelcastTypeCoercion(HazelcastSqlValidator validator) {
        super(HazelcastTypeFactory.INSTANCE, validator);
    }

    @Override
    public boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int index, RelDataType targetType) {
        SqlNode operand = call.getOperandList().get(index);
        return this.coerceNode(scope, operand, targetType, cast -> call.setOperand(index, (SqlNode)cast));
    }

    private boolean coerceNode(SqlValidatorScope scope, SqlNode node, RelDataType targetType, Consumer<SqlNode> replaceFn) {
        if (!this.requiresCast(scope, node, targetType)) {
            this.updateInferredType(node, targetType);
            return false;
        }
        SqlDataTypeSpec targetTypeSpec = targetType instanceof HazelcastIntegerType ? new SqlDataTypeSpec(new HazelcastIntegerTypeNameSpec((HazelcastIntegerType)targetType), SqlParserPos.ZERO) : SqlTypeUtil.convertTypeToSpec(targetType);
        SqlCall cast = HazelcastSqlOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, targetTypeSpec);
        replaceFn.accept(cast);
        this.validator.deriveType(scope, cast);
        return true;
    }

    @Override
    protected boolean coerceColumnType(SqlValidatorScope scope, SqlNodeList nodeList, int index, RelDataType targetType) {
        throw new UnsupportedOperationException("Should not be called");
    }

    private boolean requiresCast(SqlValidatorScope scope, SqlNode node, RelDataType to) {
        RelDataType from = this.validator.deriveType(scope, node);
        if (from.getSqlTypeName() == SqlTypeName.NULL || SqlUtil.isNullLiteral(node, false) || node.getKind() == SqlKind.DYNAMIC_PARAM) {
            return false;
        }
        return from.getSqlTypeName() != to.getSqlTypeName();
    }

    @Override
    public boolean binaryArithmeticCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean binaryComparisonCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean rowTypeCoercion(SqlValidatorScope scope, SqlNode query, int columnIndex, RelDataType targetType) {
        switch (query.getKind()) {
            case SELECT: {
                SqlSelect selectNode = (SqlSelect)query;
                SqlValidatorScope scope1 = this.validator.getSelectScope(selectNode);
                if (!this.rowTypeElementCoercion(scope1, selectNode.getSelectList().get(columnIndex), targetType, newNode -> selectNode.getSelectList().set(columnIndex, (SqlNode)newNode))) {
                    return false;
                }
                this.updateInferredColumnType(scope1, query, columnIndex, targetType);
                return true;
            }
            case VALUES: {
                for (SqlNode rowConstructor : ((SqlCall)query).getOperandList()) {
                    if (this.rowTypeElementCoercion(scope, (SqlNode)((SqlCall)rowConstructor).operand(columnIndex), targetType, newNode -> ((SqlCall)rowConstructor).setOperand(columnIndex, (SqlNode)newNode))) continue;
                    return false;
                }
                this.updateInferredColumnType(scope, query, columnIndex, targetType);
                return true;
            }
        }
        throw new UnsupportedOperationException("unexpected: " + (Object)((Object)query.getKind()));
    }

    private boolean rowTypeElementCoercion(SqlValidatorScope scope, SqlNode rowElement, RelDataType targetType, Consumer<SqlNode> replaceFn) {
        boolean valid;
        RelDataType sourceType = this.validator.deriveType(scope, rowElement);
        QueryDataType sourceHzType = HazelcastTypeUtils.toHazelcastType(sourceType.getSqlTypeName());
        QueryDataType targetHzType = HazelcastTypeUtils.toHazelcastType(targetType.getSqlTypeName());
        if (sourceHzType.getTypeFamily() == targetHzType.getTypeFamily()) {
            return true;
        }
        boolean bl = valid = HazelcastTypeCoercion.sourceAndTargetAreNumeric(targetHzType, sourceHzType) || HazelcastTypeCoercion.sourceAndTargetAreTemporalAndSourceCanBeConvertedToTarget(targetHzType, sourceHzType) || HazelcastTypeCoercion.targetIsTemporalAndSourceIsVarcharLiteral(targetHzType, sourceHzType, rowElement);
        if (!valid) {
            return false;
        }
        this.coerceNode(scope, rowElement, targetType, replaceFn);
        return true;
    }

    private static boolean sourceAndTargetAreNumeric(QueryDataType highHZType, QueryDataType lowHZType) {
        return highHZType.getTypeFamily().isNumeric() && lowHZType.getTypeFamily().isNumeric();
    }

    private static boolean sourceAndTargetAreTemporalAndSourceCanBeConvertedToTarget(QueryDataType targetHzType, QueryDataType sourceHzType) {
        return targetHzType.getTypeFamily().isTemporal() && sourceHzType.getTypeFamily().isTemporal() && sourceHzType.getConverter().canConvertTo(targetHzType.getTypeFamily());
    }

    private static boolean targetIsTemporalAndSourceIsVarcharLiteral(QueryDataType targetHzType, QueryDataType sourceHzType, SqlNode sourceNode) {
        return targetHzType.getTypeFamily().isTemporal() && sourceHzType.getTypeFamily() == QueryDataTypeFamily.VARCHAR && sourceNode instanceof SqlLiteral;
    }

    @Override
    public boolean caseWhenCoercion(SqlCallBinding callBinding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean inOperationCoercion(SqlCallBinding binding) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean builtinFunctionCoercion(SqlCallBinding binding, List<RelDataType> operandTypes, List<SqlTypeFamily> expectedFamilies) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean userDefinedFunctionCoercion(SqlValidatorScope scope, SqlCall call, SqlFunction function) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public boolean querySourceCoercion(SqlValidatorScope scope, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        RelDataType targetType;
        List<RelDataTypeField> sourceFields = sourceRowType.getFieldList();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            RelDataType sourceType = sourceFields.get(i).getType();
            targetType = targetFields.get(i).getType();
            if (SqlTypeUtil.equalSansNullability(this.validator.getTypeFactory(), sourceType, targetType) || HazelcastTypeUtils.canCast(sourceType, targetType)) continue;
            return false;
        }
        boolean canAssign = true;
        for (int i = 0; i < sourceFields.size() && canAssign; ++i) {
            targetType = targetFields.get(i).getType();
            canAssign = this.coerceSourceRowType(scope, query, i, targetType);
        }
        return canAssign;
    }

    private boolean coerceSourceRowType(SqlValidatorScope sourceScope, SqlNode query, int columnIndex, RelDataType targetType) {
        switch (query.getKind()) {
            case INSERT: {
                SqlInsert insert = (SqlInsert)query;
                return this.coerceSourceRowType(sourceScope, insert.getSource(), columnIndex, targetType);
            }
            case UPDATE: {
                SqlUpdate update = (SqlUpdate)query;
                if (update.getSourceExpressionList() != null) {
                    SqlNodeList sourceExpressionList = update.getSourceExpressionList();
                    return this.coerceColumnType(sourceScope, sourceExpressionList, columnIndex, targetType);
                }
                return this.coerceSourceRowType(sourceScope, update.getSourceSelect(), columnIndex, targetType);
            }
        }
        return this.rowTypeCoercion(sourceScope, query, columnIndex, targetType);
    }
}

