/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.SqlRowImpl;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public final class SqlPage {
    private final List<SqlColumnType> columnTypes;
    private final DataHolder data;
    private final boolean last;

    private SqlPage(List<SqlColumnType> columnTypes, DataHolder data, boolean last) {
        this.columnTypes = columnTypes;
        this.data = data;
        this.last = last;
    }

    public static SqlPage fromRows(List<SqlColumnType> columnTypes, List<SqlRow> rows, boolean last, InternalSerializationService serializationService) {
        return new SqlPage(columnTypes, new RowsetDataHolder(rows, serializationService), last);
    }

    public static SqlPage fromColumns(List<SqlColumnType> columnTypes, List<List<?>> columns, boolean last) {
        return new SqlPage(columnTypes, new ColumnarDataHolder(columns), last);
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.columnTypes.size();
    }

    public List<SqlColumnType> getColumnTypes() {
        return this.columnTypes;
    }

    public Object getColumnValueForClient(int columnIndex, int rowIndex) {
        assert (columnIndex < this.getColumnCount());
        assert (rowIndex < this.getRowCount());
        return this.data.getColumnValueForClient(columnIndex, rowIndex);
    }

    public Iterable<?> getColumnValuesForServer(int columnIndex) {
        assert (columnIndex < this.getColumnCount());
        SqlColumnType columnType = this.columnTypes.get(columnIndex);
        return this.data.getColumnValuesForServer(columnIndex, columnType);
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlPage page = (SqlPage)o;
        return this.last == page.last && this.columnTypes.equals(page.columnTypes) && this.data.equals(page.data);
    }

    public int hashCode() {
        int result = this.columnTypes.hashCode();
        result = 31 * result + this.data.hashCode();
        result = 31 * result + (this.last ? 1 : 0);
        return result;
    }

    public static boolean convertToData(SqlColumnType type) {
        return type == SqlColumnType.OBJECT;
    }

    private static final class RowsetColumnIterator
    implements Iterator<Object> {
        private final List<SqlRow> rows;
        private final InternalSerializationService serializationService;
        private final int columnIndex;
        private final boolean convertToData;
        private final int count;
        private int position;

        private RowsetColumnIterator(List<SqlRow> rows, InternalSerializationService serializationService, int columnIndex, boolean convertToData) {
            this.rows = rows;
            this.serializationService = serializationService;
            this.columnIndex = columnIndex;
            this.convertToData = convertToData;
            this.count = rows.size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.count;
        }

        @Override
        public Object next() {
            if (this.position == this.count) {
                throw new NoSuchElementException();
            }
            Object res = ((SqlRowImpl)this.rows.get(this.position)).getObjectRaw(this.columnIndex);
            if (this.convertToData) {
                res = this.serializationService.toData(res);
            }
            ++this.position;
            return res;
        }
    }

    private static final class RowsetColumnIterable
    implements Iterable<Object> {
        private final List<SqlRow> rows;
        private final InternalSerializationService serializationService;
        private final int columnIndex;
        private final boolean convertToData;

        private RowsetColumnIterable(List<SqlRow> rows, InternalSerializationService serializationService, int columnIndex, boolean convertToData) {
            this.rows = rows;
            this.serializationService = serializationService;
            this.columnIndex = columnIndex;
            this.convertToData = convertToData;
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return new RowsetColumnIterator(this.rows, this.serializationService, this.columnIndex, this.convertToData);
        }
    }

    private static final class NullTypeIterator
    implements Iterator<Object> {
        private final int count;
        private int position;

        private NullTypeIterator(int count) {
            this.count = count;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.count;
        }

        @Override
        public Object next() {
            if (this.position == this.count) {
                throw new NoSuchElementException();
            }
            ++this.position;
            return null;
        }
    }

    private static final class NullTypeIterable
    implements Iterable<Object> {
        private final int count;

        private NullTypeIterable(int count) {
            this.count = count;
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return new NullTypeIterator(this.count);
        }
    }

    private static final class ColumnarDataHolder
    implements DataHolder {
        private final List<List<?>> columns;

        private ColumnarDataHolder(List<List<?>> columns) {
            this.columns = columns;
        }

        @Override
        public int getRowCount() {
            return this.columns.get(0).size();
        }

        @Override
        public Object getColumnValueForClient(int columnIndex, int rowIndex) {
            return this.columns.get(columnIndex).get(rowIndex);
        }

        @Override
        public Iterable<?> getColumnValuesForServer(int columnIndex, SqlColumnType columnType) {
            assert (!SqlPage.convertToData(columnType));
            return this.columns.get(columnIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnarDataHolder that = (ColumnarDataHolder)o;
            return this.columns.equals(that.columns);
        }

        public int hashCode() {
            return this.columns.hashCode();
        }
    }

    private static final class RowsetDataHolder
    implements DataHolder {
        private final List<SqlRow> rows;
        private final InternalSerializationService serializationService;

        private RowsetDataHolder(List<SqlRow> rows, InternalSerializationService serializationService) {
            this.rows = rows;
            this.serializationService = serializationService;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getColumnValueForClient(int columnIndex, int rowIndex) {
            throw new UnsupportedOperationException("Should not be called.");
        }

        public Iterable<Object> getColumnValuesForServer(int columnIndex, SqlColumnType columnType) {
            if (columnType == SqlColumnType.NULL) {
                return new NullTypeIterable(this.getRowCount());
            }
            boolean convertToData = SqlPage.convertToData(columnType);
            return new RowsetColumnIterable(this.rows, this.serializationService, columnIndex, convertToData);
        }
    }

    private static interface DataHolder {
        public int getRowCount();

        public Object getColumnValueForClient(int var1, int var2);

        public Iterable<?> getColumnValuesForServer(int var1, SqlColumnType var2);
    }
}

