/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.executorservice;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceSubmitToMemberCodec;
import com.hazelcast.client.impl.protocol.task.AbstractTargetMessageTask;
import com.hazelcast.executor.impl.operations.MemberCallableTaskOperation;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.security.SecureCallable;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

public class ExecutorServiceSubmitToAddressMessageTask
extends AbstractTargetMessageTask<ExecutorServiceSubmitToMemberCodec.RequestParameters> {
    public ExecutorServiceSubmitToAddressMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected UUID getTargetUuid() {
        return ((ExecutorServiceSubmitToMemberCodec.RequestParameters)this.parameters).memberUUID;
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.clientEngine.getSecurityContext();
        Data callableData = ((ExecutorServiceSubmitToMemberCodec.RequestParameters)this.parameters).callable;
        if (securityContext != null) {
            Subject subject = this.endpoint.getSubject();
            Object taskObject = this.serializationService.toObject(((ExecutorServiceSubmitToMemberCodec.RequestParameters)this.parameters).callable);
            SecureCallable<Object> callable = taskObject instanceof Runnable ? securityContext.createSecureCallable(subject, (Runnable)taskObject) : securityContext.createSecureCallable(subject, (Callable)taskObject);
            callableData = this.serializationService.toData(callable);
        }
        MemberCallableTaskOperation op = new MemberCallableTaskOperation(((ExecutorServiceSubmitToMemberCodec.RequestParameters)this.parameters).name, ((ExecutorServiceSubmitToMemberCodec.RequestParameters)this.parameters).uuid, callableData);
        op.setCallerUuid(this.endpoint.getUuid());
        return op;
    }

    @Override
    protected ExecutorServiceSubmitToMemberCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ExecutorServiceSubmitToMemberCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        Object data = this.serializationService.toData(response);
        return ExecutorServiceSubmitToMemberCodec.encodeResponse(data);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return ((ExecutorServiceSubmitToMemberCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

