/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.com.google.common.base.Predicate;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import com.hazelcast.org.apache.calcite.interpreter.Bindables;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.rex.RexVisitorImpl;
import com.hazelcast.org.apache.calcite.schema.ProjectableFilterableTable;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.mapping.Mapping;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ProjectTableScanRule
extends RelOptRule {
    @Deprecated
    public static final Predicate<TableScan> PREDICATE = ProjectTableScanRule::test;
    public static final ProjectTableScanRule INSTANCE = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operandJ(TableScan.class, null, ProjectTableScanRule::test, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ProjectScanRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, project, scan);
        }
    };
    public static final ProjectTableScanRule INTERPRETER = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operand(EnumerableInterpreter.class, ProjectTableScanRule.operandJ(TableScan.class, null, ProjectTableScanRule::test, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ProjectScanRule:interpreter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, project, scan);
        }
    };

    public ProjectTableScanRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    protected static boolean test(TableScan scan) {
        RelOptTable table = scan.getTable();
        return table.unwrap(ProjectableFilterableTable.class) != null;
    }

    protected void apply(RelOptRuleCall call, Project project, TableScan scan) {
        List<Integer> projectsPushDown;
        ImmutableList<RexNode> filtersPushDown;
        RelOptTable table = scan.getTable();
        assert (table.unwrap(ProjectableFilterableTable.class) != null);
        final ArrayList<Integer> selectedColumns = new ArrayList<Integer>();
        project.getProjects().forEach(proj -> proj.accept(new RexVisitorImpl<Void>(true){

            @Override
            public Void visitInputRef(RexInputRef inputRef) {
                if (!selectedColumns.contains(inputRef.getIndex())) {
                    selectedColumns.add(inputRef.getIndex());
                }
                return null;
            }
        }));
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filtersPushDown = bindableScan.filters;
            projectsPushDown = selectedColumns.stream().map(col -> bindableScan.projects.get((int)col)).collect(Collectors.toList());
        } else {
            filtersPushDown = ImmutableList.of();
            projectsPushDown = selectedColumns;
        }
        Bindables.BindableTableScan newScan = Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), filtersPushDown, projectsPushDown);
        Mapping mapping = Mappings.target(selectedColumns, scan.getRowType().getFieldCount());
        ImmutableList<RexNode> newProjectRexNodes = ImmutableList.copyOf(RexUtil.apply((Mappings.TargetMapping)mapping, project.getProjects()));
        if (RexUtil.isIdentity(newProjectRexNodes, newScan.getRowType())) {
            call.transformTo(newScan);
        } else {
            call.transformTo(call.builder().push(newScan).project(newProjectRexNodes).build());
        }
    }
}

