/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.topic;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TopicAddMessageListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import com.hazelcast.topic.impl.DataAwareMessage;
import com.hazelcast.topic.impl.TopicService;
import java.security.Permission;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class TopicAddMessageListenerMessageTask
extends AbstractAddListenerMessageTask<TopicAddMessageListenerCodec.RequestParameters>
implements MessageListener {
    private Data partitionKey;
    private Random rand = new Random();

    public TopicAddMessageListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        this.partitionKey = this.serializationService.toData(((TopicAddMessageListenerCodec.RequestParameters)this.parameters).name);
        TopicService service = (TopicService)this.getService("hz:impl:topicService");
        if (((TopicAddMessageListenerCodec.RequestParameters)this.parameters).localOnly) {
            return InternalCompletableFuture.newCompletedFuture(service.addLocalMessageListener(((TopicAddMessageListenerCodec.RequestParameters)this.parameters).name, this));
        }
        return (CompletableFuture)service.addMessageListenerAsync(((TopicAddMessageListenerCodec.RequestParameters)this.parameters).name, this);
    }

    @Override
    protected TopicAddMessageListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return TopicAddMessageListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return TopicAddMessageListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new TopicPermission(((TopicAddMessageListenerCodec.RequestParameters)this.parameters).name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return ((TopicAddMessageListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "addMessageListener";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{null};
    }

    public void onMessage(Message message) {
        if (!this.endpoint.isAlive()) {
            return;
        }
        if (!(message instanceof DataAwareMessage)) {
            throw new IllegalArgumentException("Expecting: DataAwareMessage, Found: " + message.getClass().getSimpleName());
        }
        DataAwareMessage dataAwareMessage = (DataAwareMessage)message;
        Data messageData = dataAwareMessage.getMessageData();
        UUID publisherUuid = message.getPublishingMember().getUuid();
        ClientMessage eventMessage = TopicAddMessageListenerCodec.encodeTopicEvent(messageData, message.getPublishTime(), publisherUuid);
        boolean isMultithreaded = this.nodeEngine.getConfig().findTopicConfig(((TopicAddMessageListenerCodec.RequestParameters)this.parameters).name).isMultiThreadingEnabled();
        if (isMultithreaded) {
            int key = this.rand.nextInt();
            int partitionId = HashUtil.hashToIndex(key, this.nodeEngine.getPartitionService().getPartitionCount());
            eventMessage.setPartitionId(partitionId);
            this.sendClientMessage(eventMessage);
        } else {
            this.sendClientMessage(this.partitionKey, eventMessage);
        }
    }
}

