/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;

@SerializableByConvention
public class SampleableConcurrentHashMap<K, V>
extends ConcurrentReferenceHashMap<K, V> {
    private static final float LOAD_FACTOR = 0.91f;

    public SampleableConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    }

    public SampleableConcurrentHashMap(int initialCapacity, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType) {
        this(initialCapacity, 0.91f, 1, keyType, valueType, null);
    }

    private SampleableConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, ConcurrentReferenceHashMap.ReferenceType keyType, ConcurrentReferenceHashMap.ReferenceType valueType, EnumSet<ConcurrentReferenceHashMap.Option> options) {
        super(initialCapacity, loadFactor, concurrencyLevel, keyType, valueType, options);
    }

    public IterationPointer[] fetchKeys(IterationPointer[] pointers, int size, List<K> keys) {
        return this.fetchNext(pointers, size, (k, v) -> keys.add(k));
    }

    public IterationPointer[] fetchEntries(IterationPointer[] pointers, int size, List<Map.Entry<K, V>> entries) {
        return this.fetchNext(pointers, size, (k, v) -> entries.add(new AbstractMap.SimpleEntry<Object, Object>(k, v)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IterationPointer[] fetchNext(IterationPointer[] pointers, int size, BiConsumer<K, V> entryConsumer) {
        long now = Clock.currentTimeMillis();
        ConcurrentReferenceHashMap.Segment segment = this.segments[0];
        try {
            segment.lock();
            ConcurrentReferenceHashMap.HashEntry<K, V>[] currentTable = segment.table;
            int currentTableSize = currentTable.length;
            pointers = this.checkPointers(pointers, currentTableSize);
            IterationPointer lastPointer = pointers[pointers.length - 1];
            int nextTableIndex = lastPointer.getIndex() >= 0 && lastPointer.getIndex() < segment.table.length ? lastPointer.getIndex() : currentTable.length - 1;
            int counter = 0;
            while (nextTableIndex >= 0 && counter < size) {
                ConcurrentReferenceHashMap.HashEntry nextEntry = currentTable[nextTableIndex--];
                while (nextEntry != null) {
                    Object key;
                    Object value = nextEntry.value();
                    if (this.isValidForFetching(value, now) && (key = nextEntry.key()) != null && this.hasNotBeenObserved(key, pointers)) {
                        entryConsumer.accept(key, value);
                        ++counter;
                    }
                    nextEntry = nextEntry.next;
                }
            }
            lastPointer.setIndex(nextTableIndex);
            IterationPointer[] iterationPointerArray = pointers;
            return iterationPointerArray;
        }
        finally {
            segment.unlock();
        }
    }

    private IterationPointer[] checkPointers(IterationPointer[] pointers, int currentTableSize) {
        IterationPointer lastPointer = pointers[pointers.length - 1];
        boolean iterationStarted = lastPointer.getSize() == -1;
        boolean tableResized = lastPointer.getSize() != currentTableSize;
        int newLength = !iterationStarted && tableResized ? pointers.length + 1 : pointers.length;
        IterationPointer[] updatedPointers = new IterationPointer[newLength];
        for (int i = 0; i < pointers.length; ++i) {
            updatedPointers[i] = new IterationPointer(pointers[i]);
        }
        if (iterationStarted || tableResized) {
            updatedPointers[updatedPointers.length - 1] = new IterationPointer(Integer.MAX_VALUE, currentTableSize);
        }
        return updatedPointers;
    }

    private boolean hasNotBeenObserved(K key, IterationPointer[] pointers) {
        if (pointers.length < 2) {
            return true;
        }
        int hash = this.hashOf(key);
        for (int i = 0; i < pointers.length - 1; ++i) {
            int tableIndex;
            IterationPointer iterationPointer = pointers[i];
            int tableSize = iterationPointer.getSize();
            int index = hash & tableSize - 1;
            if (index <= (tableIndex = iterationPointer.getIndex())) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidForFetching(V value, long now) {
        if (value instanceof Expirable) {
            return !((Expirable)value).isExpiredAt(now);
        }
        return true;
    }

    protected <E extends SamplingEntry> E createSamplingEntry(K key, V value) {
        return (E)new SamplingEntry<K, V>(key, value);
    }

    public <E extends SamplingEntry> Iterable<E> getRandomSamples(int sampleCount) {
        if (sampleCount < 0) {
            throw new IllegalArgumentException("Sample count cannot be a negative value.");
        }
        if (sampleCount == 0 || this.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return new LazySamplingEntryIterableIterator(sampleCount);
    }

    protected boolean isValidForSampling(K key, V value) {
        return key != null && value != null;
    }

    private final class LazySamplingEntryIterableIterator<E extends SamplingEntry>
    implements Iterable<E>,
    Iterator<E> {
        private final int maxEntryCount;
        private final int randomNumber;
        private final int firstSegmentIndex;
        private int currentSegmentIndex;
        private int currentBucketIndex;
        private ConcurrentReferenceHashMap.HashEntry<K, V> mostRecentlyReturnedEntry;
        private int returnedEntryCount;
        private boolean reachedToEnd;
        private E currentSample;

        private LazySamplingEntryIterableIterator(int maxEntryCount) {
            this.maxEntryCount = maxEntryCount;
            this.randomNumber = ThreadLocalRandomProvider.get().nextInt(Integer.MAX_VALUE);
            this.currentSegmentIndex = this.firstSegmentIndex = this.randomNumber % SampleableConcurrentHashMap.this.segments.length;
            this.currentBucketIndex = -1;
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        private void iterate() {
            if (this.returnedEntryCount >= this.maxEntryCount || this.reachedToEnd) {
                this.currentSample = null;
                return;
            }
            do {
                ConcurrentReferenceHashMap.Segment segment;
                if ((segment = SampleableConcurrentHashMap.this.segments[this.currentSegmentIndex]) != null) {
                    ConcurrentReferenceHashMap.HashEntry<K, V>[] table = segment.table;
                    int firstBucketIndex = this.randomNumber % table.length;
                    if (this.currentBucketIndex == -1) {
                        this.currentBucketIndex = firstBucketIndex;
                    }
                    do {
                        this.mostRecentlyReturnedEntry = this.mostRecentlyReturnedEntry == null ? table[this.currentBucketIndex] : this.mostRecentlyReturnedEntry.next;
                        while (this.mostRecentlyReturnedEntry != null) {
                            Object value = this.mostRecentlyReturnedEntry.value();
                            Object key = this.mostRecentlyReturnedEntry.key();
                            if (SampleableConcurrentHashMap.this.isValidForSampling(key, value)) {
                                this.currentSample = SampleableConcurrentHashMap.this.createSamplingEntry(key, value);
                                ++this.returnedEntryCount;
                                return;
                            }
                            this.mostRecentlyReturnedEntry = this.mostRecentlyReturnedEntry.next;
                        }
                        int n = this.currentBucketIndex = ++this.currentBucketIndex < table.length ? this.currentBucketIndex : 0;
                    } while (this.currentBucketIndex != firstBucketIndex);
                }
                this.currentSegmentIndex = ++this.currentSegmentIndex < SampleableConcurrentHashMap.this.segments.length ? this.currentSegmentIndex : 0;
                this.currentBucketIndex = -1;
                this.mostRecentlyReturnedEntry = null;
            } while (this.currentSegmentIndex != this.firstSegmentIndex);
            this.reachedToEnd = true;
            this.currentSample = null;
        }

        @Override
        public boolean hasNext() {
            if (this.currentSample == null) {
                this.iterate();
            }
            return this.currentSample != null;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                E returnValue = this.currentSample;
                this.currentSample = null;
                return returnValue;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is not supported");
        }
    }

    public static class SamplingEntry<K, V> {
        protected final K key;
        protected final V value;

        public SamplingEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getEntryKey() {
            return this.key;
        }

        public V getEntryValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SamplingEntry)) {
                return false;
            }
            SamplingEntry e = (SamplingEntry)o;
            return Objects.equals(this.key, e.key) && Objects.equals(this.value, e.value);
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

