/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.gcp;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.gcp.RestClient;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

class GcpAuthenticator {
    private static final String GOOGLE_AUTH_ENDPOINT = "https://www.googleapis.com/oauth2/v4/token";
    private static final String SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private final String endpoint;

    GcpAuthenticator() {
        this(GOOGLE_AUTH_ENDPOINT);
    }

    GcpAuthenticator(String endpoint) {
        this.endpoint = endpoint;
    }

    String refreshAccessToken(String privateKeyPath) {
        return this.refreshAccessToken(privateKeyPath, System.currentTimeMillis());
    }

    String refreshAccessToken(String privateKeyPath, long currentTimeMs) {
        try {
            String body = this.createBody(privateKeyPath, currentTimeMs);
            String response = this.callService(body);
            return GcpAuthenticator.parseResponse(response);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException(String.format("Private key json file not found. Please ensure you have stored the json file at the specified file path: %s", privateKeyPath), e);
        }
        catch (Exception e) {
            throw new HazelcastException("Error while fetching access token from Google API", e);
        }
    }

    private String createBody(String privateKeyPath, long currentTimeMs) throws Exception {
        JsonObject privateKeyJson = Json.parse(new InputStreamReader((InputStream)new FileInputStream(privateKeyPath), "UTF-8")).asObject();
        String privateKey = privateKeyJson.get("private_key").asString();
        String clientEmail = privateKeyJson.get("client_email").asString();
        String headerBase64 = GcpAuthenticator.base64encodeUrlSafe(GcpAuthenticator.header());
        String claimSetBase64 = GcpAuthenticator.base64encodeUrlSafe(this.claimSet(clientEmail, currentTimeMs));
        String signatureBase64 = GcpAuthenticator.sign(headerBase64, claimSetBase64, privateKey);
        return GcpAuthenticator.body(headerBase64, claimSetBase64, signatureBase64);
    }

    private static String header() {
        return "{\"alg\":\"RS256\",\"typ\":\"JWT\"}";
    }

    private String claimSet(String clientEmail, long currentTimeMs) {
        long currentTimeSeconds = currentTimeMs / 1000L;
        long expirationTimeSeconds = currentTimeSeconds + 3600L;
        return String.format("{\"iss\":\"%s\",\"scope\":\"%s\",\"aud\":\"%s\",\"iat\":%s,\"exp\":%s}", clientEmail, SCOPE, this.endpoint, currentTimeSeconds, expirationTimeSeconds);
    }

    private static String body(String headerBase64, String claimSetBase64, String signatureBase64) {
        String grantType = "urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Ajwt-bearer";
        String assertion = String.format("%s.%s.%s", headerBase64, claimSetBase64, signatureBase64);
        return String.format("grant_type=%s&assertion=%s", grantType, assertion);
    }

    private static String sign(String headerBase64, String claimSetBase64, String privateKeyString) throws Exception {
        String dataToSign = String.format("%s.%s", headerBase64, claimSetBase64);
        String clearPrivateKeyString = GcpAuthenticator.clear(privateKeyString);
        byte[] b1 = Base64.getMimeDecoder().decode(clearPrivateKeyString.getBytes("UTF-8"));
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(b1);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        Signature privateSignature = Signature.getInstance("SHA256withRSA");
        PrivateKey privateKey = kf.generatePrivate(spec);
        privateSignature.initSign(privateKey);
        privateSignature.update(dataToSign.getBytes("UTF-8"));
        return new String(GcpAuthenticator.base64encodeUrlSafe(privateSignature.sign()), "UTF-8");
    }

    private static String clear(String privateKey) {
        return privateKey.replaceAll("-----END PRIVATE KEY-----", "").replaceAll("-----BEGIN PRIVATE KEY-----", "").replaceAll("\\\\n", "");
    }

    private static String base64encodeUrlSafe(String data) throws UnsupportedEncodingException {
        byte[] encoded = GcpAuthenticator.base64encodeUrlSafe(data.getBytes("UTF-8"));
        return new String(encoded, "UTF-8");
    }

    private static byte[] base64encodeUrlSafe(byte[] data) {
        byte[] encode = Base64.getEncoder().encode(data);
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] == 43) {
                encode[i] = 45;
                continue;
            }
            if (encode[i] != 47) continue;
            encode[i] = 95;
        }
        return encode;
    }

    private String callService(String body) {
        return RestClient.create(this.endpoint).withBody(body).post();
    }

    private static String parseResponse(String response) {
        return Json.parse(response).asObject().get("access_token").asString();
    }
}

