/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.plan.node.UniInputPlanNode;
import java.io.IOException;
import java.util.Objects;

public class FilterPlanNode
extends UniInputPlanNode
implements IdentifiedDataSerializable {
    private Expression<Boolean> filter;

    public FilterPlanNode() {
    }

    public FilterPlanNode(int id, PlanNode upstream, Expression<Boolean> filter) {
        super(id, upstream);
        assert (filter != null);
        this.filter = filter;
    }

    public Expression<Boolean> getFilter() {
        return this.filter;
    }

    @Override
    public void visit0(PlanNodeVisitor visitor) {
        visitor.onFilterNode(this);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    @Override
    public void writeData1(ObjectDataOutput out) throws IOException {
        out.writeObject(this.filter);
    }

    @Override
    public void readData1(ObjectDataInput in) throws IOException {
        this.filter = (Expression)in.readObject();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.filter, this.upstream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterPlanNode that = (FilterPlanNode)o;
        return this.id == that.id && this.filter.equals(that.filter) && this.upstream.equals(that.upstream);
    }
}

