/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package com.hazelcast.org.apache.hc.client5.http.impl;

import java.util.Iterator;

import com.hazelcast.org.apache.hc.core5.http.Header;
import com.hazelcast.org.apache.hc.core5.http.HttpRequest;
import com.hazelcast.org.apache.hc.core5.http.message.BasicHttpRequest;

/**
 * {@link HttpRequest} copier.
 *
 * @since 5.0
 *
 * @deprecated Use {@link com.hazelcast.org.apache.hc.core5.http.support.BasicRequestBuilder}
 */
@Deprecated
public final class RequestCopier implements MessageCopier<HttpRequest> {

    public static final RequestCopier INSTANCE = new RequestCopier();

    @Override
    public HttpRequest copy(final HttpRequest original) {
        if (original == null) {
            return null;
        }
        final BasicHttpRequest copy = new BasicHttpRequest(original.getMethod(), null, original.getPath());
        copy.setScheme(original.getScheme());
        copy.setAuthority(original.getAuthority());
        copy.setVersion(original.getVersion());
        for (final Iterator<Header> it = original.headerIterator(); it.hasNext(); ) {
            copy.addHeader(it.next());
        }
        return copy;
    }

}
