/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package com.hazelcast.org.apache.hc.core5.pool;

import com.hazelcast.org.apache.hc.core5.annotation.Internal;
import com.hazelcast.org.apache.hc.core5.http.SocketModalCloseable;
import com.hazelcast.org.apache.hc.core5.io.CloseMode;
import com.hazelcast.org.apache.hc.core5.util.TimeValue;
import com.hazelcast.org.apache.hc.core5.util.Timeout;

/**
 * Default implementation of {@link DisposalCallback}.
 *
 * @param <T> socket based connection type.
 *
 * @since 5.0
 */
@Internal
public final class DefaultDisposalCallback<T extends SocketModalCloseable> implements DisposalCallback<T> {

    private final static Timeout DEFAULT_CLOSE_TIMEOUT = Timeout.ofSeconds(1L);

    @Override
    public void execute(final SocketModalCloseable closeable, final CloseMode closeMode) {
        final Timeout socketTimeout = closeable.getSocketTimeout();
        if (socketTimeout == null ||
                socketTimeout.compareTo(TimeValue.ZERO_MILLISECONDS) <= 0 ||
                socketTimeout.compareTo(DEFAULT_CLOSE_TIMEOUT) > 0) {
            closeable.setSocketTimeout(DEFAULT_CLOSE_TIMEOUT);
        }
        closeable.close(closeMode);
    }

}
