/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.hc.client5.http.impl.async;

import com.hazelcast.org.apache.hc.client5.http.HttpRoute;
import com.hazelcast.org.apache.hc.client5.http.async.AsyncExecRuntime;
import com.hazelcast.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import com.hazelcast.org.apache.hc.client5.http.auth.CredentialsProvider;
import com.hazelcast.org.apache.hc.client5.http.config.RequestConfig;
import com.hazelcast.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import com.hazelcast.org.apache.hc.client5.http.cookie.CookieStore;
import com.hazelcast.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import com.hazelcast.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import com.hazelcast.org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import com.hazelcast.org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime;
import com.hazelcast.org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import com.hazelcast.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.hazelcast.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import com.hazelcast.org.apache.hc.core5.annotation.Contract;
import com.hazelcast.org.apache.hc.core5.annotation.Internal;
import com.hazelcast.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.hazelcast.org.apache.hc.core5.http.HttpException;
import com.hazelcast.org.apache.hc.core5.http.HttpHost;
import com.hazelcast.org.apache.hc.core5.http.config.Lookup;
import com.hazelcast.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import com.hazelcast.org.apache.hc.core5.http.nio.HandlerFactory;
import com.hazelcast.org.apache.hc.core5.http2.HttpVersionPolicy;
import com.hazelcast.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import com.hazelcast.org.slf4j.Logger;
import com.hazelcast.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalHttpAsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalHttpAsyncClient.class);
    private final AsyncClientConnectionManager manager;
    private final HttpRoutePlanner routePlanner;
    private final HttpVersionPolicy versionPolicy;

    InternalHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, AsyncClientConnectionManager manager, HttpRoutePlanner routePlanner, HttpVersionPolicy versionPolicy, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
        this.manager = manager;
        this.routePlanner = routePlanner;
        this.versionPolicy = versionPolicy;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpRoute route) {
        HttpVersionPolicy actualVersionPolicy = route.isTunnelled() && this.versionPolicy == HttpVersionPolicy.NEGOTIATE ? HttpVersionPolicy.FORCE_HTTP_1 : this.versionPolicy;
        return new InternalHttpAsyncExecRuntime(LOG, this.manager, this.getConnectionInitiator(), pushHandlerFactory, actualVersionPolicy);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, clientContext);
        if (route.isTunnelled() && this.versionPolicy == HttpVersionPolicy.FORCE_HTTP_2) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

