/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.client.SqlError;
import java.util.UUID;

public final class SqlClientUtils {
    private static final byte EXPECTED_RESULT_TYPE_ANY = 0;
    private static final byte EXPECTED_RESULT_TYPE_ROWS = 1;
    private static final byte EXPECTED_RESULT_TYPE_UPDATE_COUNT = 2;

    private SqlClientUtils() {
    }

    public static SqlError exceptionToClientError(Exception exception, UUID localMemberId) {
        HazelcastSqlException sqlException = QueryUtils.toPublicException(exception, localMemberId);
        return new SqlError(sqlException.getCode(), sqlException.getMessage(), sqlException.getOriginatingMemberId());
    }

    public static byte expectedResultTypeToByte(SqlExpectedResultType expectedResultType) {
        switch (expectedResultType) {
            case ANY: {
                return 0;
            }
            case ROWS: {
                return 1;
            }
        }
        assert (expectedResultType == SqlExpectedResultType.UPDATE_COUNT);
        return 2;
    }

    public static SqlExpectedResultType expectedResultTypeToEnum(byte expectedResultType) {
        switch (expectedResultType) {
            case 0: {
                return SqlExpectedResultType.ANY;
            }
            case 1: {
                return SqlExpectedResultType.ROWS;
            }
        }
        assert (expectedResultType == 2);
        return SqlExpectedResultType.UPDATE_COUNT;
    }
}

