/*
 * ====================================================================
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package com.hazelcast.org.apache.hc.client5.http.entity.mime;

/**
 * Represents common content properties.
 */
public interface ContentDescriptor {

    /**
     * Returns the body descriptors MIME type.
     * @see #getMediaType()
     * @see #getSubType()
     * @return The MIME type, which has been parsed from the
     *   content-type definition. Must not be null, but
     *   "text/plain", if no content-type was specified.
     */
    String getMimeType();

    /**
     * Gets the defaulted MIME media type for this content.
     * For example {@code TEXT}, {@code IMAGE}, {@code MULTIPART}
     * @see #getMimeType()
     * @return the MIME media type when content-type specified,
     * otherwise the correct default ({@code TEXT})
     */
    String getMediaType();

    /**
     * Gets the defaulted MIME sub type for this content.
     * @see #getMimeType()
     * @return the MIME media type when content-type is specified,
     * otherwise the correct default ({@code PLAIN})
     */
    String getSubType();

    /**
     * <p>The body descriptors character set, defaulted appropriately for the MIME type.</p>
     * <p>
     * For {@code TEXT} types, this will be defaulted to {@code us-ascii}.
     * For other types, when the charset parameter is missing this property will be null.
     * </p>
     * @return Character set, which has been parsed from the
     *   content-type definition. Not null for {@code TEXT} types, when unset will
     *   be set to default {@code us-ascii}. For other types, when unset,
     *   null will be returned.
     */
    String getCharset();

    /**
     * Returns the body descriptors content-length.
     * @return Content length, if known, or -1, to indicate the absence of a
     *   content-length header.
     */
    long getContentLength();

}
