/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel;

import com.hazelcast.com.google.common.collect.Ordering;
import com.hazelcast.org.apache.calcite.plan.RelMultipleTrait;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.org.apache.calcite.rel.RelDistributionTraitDef;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.apache.calcite.util.mapping.Mapping;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RelDistributions {
    public static final ImmutableIntList EMPTY = ImmutableIntList.of();
    public static final RelDistribution SINGLETON = new RelDistributionImpl(RelDistribution.Type.SINGLETON, EMPTY);
    public static final RelDistribution RANDOM_DISTRIBUTED = new RelDistributionImpl(RelDistribution.Type.RANDOM_DISTRIBUTED, EMPTY);
    public static final RelDistribution ROUND_ROBIN_DISTRIBUTED = new RelDistributionImpl(RelDistribution.Type.ROUND_ROBIN_DISTRIBUTED, EMPTY);
    public static final RelDistribution BROADCAST_DISTRIBUTED = new RelDistributionImpl(RelDistribution.Type.BROADCAST_DISTRIBUTED, EMPTY);
    public static final RelDistribution ANY = new RelDistributionImpl(RelDistribution.Type.ANY, EMPTY);

    private RelDistributions() {
    }

    public static RelDistribution hash(Collection<? extends Number> numbers) {
        ImmutableIntList list = RelDistributions.normalizeKeys(numbers);
        return RelDistributions.of(RelDistribution.Type.HASH_DISTRIBUTED, list);
    }

    public static RelDistribution range(Collection<? extends Number> numbers) {
        ImmutableIntList list = ImmutableIntList.copyOf(numbers);
        return RelDistributions.of(RelDistribution.Type.RANGE_DISTRIBUTED, list);
    }

    public static RelDistribution of(RelDistribution.Type type, ImmutableIntList keys) {
        RelDistributionImpl distribution = new RelDistributionImpl(type, keys);
        return RelDistributionTraitDef.INSTANCE.canonize(distribution);
    }

    private static ImmutableIntList normalizeKeys(Collection<? extends Number> keys) {
        ImmutableIntList list = ImmutableIntList.copyOf(keys);
        if (list.size() > 1 && !Ordering.natural().isOrdered(list)) {
            list = ImmutableIntList.copyOf(Ordering.natural().sortedCopy(list));
        }
        return list;
    }

    private static class RelDistributionImpl
    implements RelDistribution {
        private static final Ordering<Iterable<Integer>> ORDERING = Ordering.natural().lexicographical();
        private final RelDistribution.Type type;
        private final ImmutableIntList keys;

        private RelDistributionImpl(RelDistribution.Type type, ImmutableIntList keys) {
            this.type = Objects.requireNonNull(type);
            this.keys = ImmutableIntList.copyOf(keys);
            assert (type != RelDistribution.Type.HASH_DISTRIBUTED || keys.size() < 2 || Ordering.natural().isOrdered(keys)) : "key columns of hash distribution must be in order";
            assert (type == RelDistribution.Type.HASH_DISTRIBUTED || type == RelDistribution.Type.RANDOM_DISTRIBUTED || keys.isEmpty());
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.keys});
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof RelDistributionImpl && this.type == ((RelDistributionImpl)obj).type && this.keys.equals(((RelDistributionImpl)obj).keys);
        }

        @Override
        public String toString() {
            if (this.keys.isEmpty()) {
                return this.type.shortName;
            }
            return this.type.shortName + this.keys;
        }

        @Override
        @Nonnull
        public RelDistribution.Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public List<Integer> getKeys() {
            return this.keys;
        }

        @Override
        public RelDistributionTraitDef getTraitDef() {
            return RelDistributionTraitDef.INSTANCE;
        }

        @Override
        public RelDistribution apply(Mappings.TargetMapping mapping) {
            if (this.keys.isEmpty()) {
                return this;
            }
            for (int key : this.keys) {
                if (mapping.getTargetOpt(key) != -1) continue;
                return ANY;
            }
            List<Integer> mappedKeys0 = Mappings.apply2((Mapping)mapping, this.keys);
            ImmutableIntList mappedKeys = RelDistributions.normalizeKeys(mappedKeys0);
            return RelDistributions.of(this.type, mappedKeys);
        }

        @Override
        public boolean satisfies(RelTrait trait) {
            if (trait == this || trait == ANY) {
                return true;
            }
            if (trait instanceof RelDistributionImpl) {
                RelDistributionImpl distribution = (RelDistributionImpl)trait;
                if (this.type == distribution.type) {
                    switch (this.type) {
                        case HASH_DISTRIBUTED: {
                            return this.keys.equals(distribution.keys);
                        }
                        case RANGE_DISTRIBUTED: {
                            return Util.startsWith(distribution.keys, this.keys);
                        }
                    }
                    return true;
                }
            }
            if (trait == RANDOM_DISTRIBUTED) {
                return this.type == RelDistribution.Type.HASH_DISTRIBUTED || this.type == RelDistribution.Type.ROUND_ROBIN_DISTRIBUTED || this.type == RelDistribution.Type.RANGE_DISTRIBUTED;
            }
            return false;
        }

        @Override
        public void register(RelOptPlanner planner) {
        }

        @Override
        public boolean isTop() {
            return this.type == RelDistribution.Type.ANY;
        }

        @Override
        public int compareTo(@Nonnull RelMultipleTrait o) {
            RelDistribution distribution = (RelDistribution)o;
            if (this.type == distribution.getType() && (this.type == RelDistribution.Type.HASH_DISTRIBUTED || this.type == RelDistribution.Type.RANGE_DISTRIBUTED)) {
                return ORDERING.compare(this.getKeys(), distribution.getKeys());
            }
            return this.type.compareTo(distribution.getType());
        }
    }
}

