/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.operation.QueryAbstractIdAwareOperation;
import java.io.IOException;
import java.util.UUID;

public abstract class QueryAbstractExchangeOperation
extends QueryAbstractIdAwareOperation {
    private int edgeId;
    private UUID targetMemberId;

    public QueryAbstractExchangeOperation() {
    }

    public QueryAbstractExchangeOperation(QueryId queryId, int edgeId, UUID targetMemberId) {
        super(queryId);
        this.edgeId = edgeId;
        this.targetMemberId = targetMemberId;
    }

    public int getEdgeId() {
        return this.edgeId;
    }

    public UUID getTargetMemberId() {
        return this.targetMemberId;
    }

    public abstract boolean isInbound();

    @Override
    protected final void writeInternal1(ObjectDataOutput out) throws IOException {
        out.writeInt(this.edgeId);
        UUIDSerializationUtil.writeUUID(out, this.targetMemberId);
        this.writeInternal2(out);
    }

    @Override
    protected final void readInternal1(ObjectDataInput in) throws IOException {
        this.edgeId = in.readInt();
        this.targetMemberId = UUIDSerializationUtil.readUUID(in);
        this.readInternal2(in);
    }

    protected abstract void writeInternal2(ObjectDataOutput var1) throws IOException;

    protected abstract void readInternal2(ObjectDataInput var1) throws IOException;
}

