/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.row;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.row.Row;
import java.io.IOException;
import java.util.Objects;

public class JoinRow
implements Row,
IdentifiedDataSerializable {
    private Row left;
    private Row right;

    public JoinRow() {
    }

    public JoinRow(Row left, Row right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public <T> T get(int idx) {
        int leftColumnCount = this.left.getColumnCount();
        if (idx < leftColumnCount) {
            return this.left.get(idx);
        }
        return this.right.get(idx - leftColumnCount);
    }

    @Override
    public int getColumnCount() {
        return this.left.getColumnCount() + this.right.getColumnCount();
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.left);
        out.writeObject(this.right);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.left = (Row)in.readObject();
        this.right = (Row)in.readObject();
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinRow joinRow = (JoinRow)o;
        return this.left.equals(joinRow.left) && this.right.equals(joinRow.right);
    }
}

