/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Litmus;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.apache.calcite.util.Util;
import java.math.BigDecimal;
import java.nio.charset.Charset;

public class SqlBinaryOperator
extends SqlOperator {
    public SqlBinaryOperator(String name, SqlKind kind, int prec, boolean leftAssoc, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlBinaryOperator.leftPrec(prec, leftAssoc), SqlBinaryOperator.rightPrec(prec, leftAssoc), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.BINARY;
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{1} {0} {2}";
    }

    @Override
    boolean needsSpace() {
        return !this.getName().equals(".");
    }

    @Override
    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        RelDataType operandType1 = validator.getValidatedNodeType((SqlNode)call.operand(0));
        RelDataType operandType2 = validator.getValidatedNodeType((SqlNode)call.operand(1));
        if (SqlTypeUtil.inCharFamily(operandType1) && SqlTypeUtil.inCharFamily(operandType2)) {
            Charset cs1 = operandType1.getCharset();
            Charset cs2 = operandType2.getCharset();
            assert (null != cs1 && null != cs2) : "An implicit or explicit charset should have been set";
            if (!cs1.equals(cs2)) {
                throw validator.newValidationError(call, Static.RESOURCE.incompatibleCharset(this.getName(), cs1.name(), cs2.name()));
            }
            SqlCollation col1 = operandType1.getCollation();
            SqlCollation col2 = operandType2.getCollation();
            assert (null != col1 && null != col2) : "An implicit or explicit collation should have been set";
            SqlCollation resultCol = SqlCollation.getCoercibilityDyadicOperator(col1, col2);
            if (SqlTypeUtil.inCharFamily(type)) {
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, type.getCharset(), resultCol);
            }
        }
        return type;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataType type = super.deriveType(validator, scope, call);
        RelDataType operandType1 = validator.getValidatedNodeType((SqlNode)call.operand(0));
        RelDataType operandType2 = validator.getValidatedNodeType((SqlNode)call.operand(1));
        if (SqlTypeUtil.inCharFamily(operandType1) && SqlTypeUtil.inCharFamily(operandType2)) {
            Charset cs1 = operandType1.getCharset();
            Charset cs2 = operandType2.getCharset();
            assert (null != cs1 && null != cs2) : "An implicit or explicit charset should have been set";
            if (!cs1.equals(cs2)) {
                throw validator.newValidationError(call, Static.RESOURCE.incompatibleCharset(this.getName(), cs1.name(), cs2.name()));
            }
            SqlCollation col1 = operandType1.getCollation();
            SqlCollation col2 = operandType2.getCollation();
            assert (null != col1 && null != col2) : "An implicit or explicit collation should have been set";
            SqlCollation resultCol = SqlCollation.getCoercibilityDyadicOperator(col1, col2);
            if (SqlTypeUtil.inCharFamily(type)) {
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, type.getCharset(), resultCol);
            }
        }
        return type;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        if (this.getName().equals("/")) {
            SqlMonotonicity mono0 = call.getOperandMonotonicity(0);
            SqlMonotonicity mono1 = call.getOperandMonotonicity(1);
            if (mono1 == SqlMonotonicity.CONSTANT && call.isOperandLiteral(1, false)) {
                switch (call.getOperandLiteralValue(1, BigDecimal.class).signum()) {
                    case -1: {
                        return mono0.reverse().unstrict();
                    }
                    case 0: {
                        return SqlMonotonicity.CONSTANT;
                    }
                }
                return mono0.unstrict();
            }
        }
        return super.getMonotonicity(call);
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count != 2) {
            if ((this == SqlStdOperatorTable.AND || this == SqlStdOperatorTable.OR) && count > 2) {
                return true;
            }
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }
}

