/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.fetch;

import com.hazelcast.sql.impl.exec.AbstractUpstreamAwareExec;
import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.exec.fetch.Fetch;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;

public class FetchExec
extends AbstractUpstreamAwareExec {
    private final Fetch fetch;
    private RowBatch currentBatch;

    public FetchExec(int id, Exec upstream, Expression fetch, Expression offset) {
        super(id, upstream);
        this.fetch = new Fetch(fetch, offset);
    }

    @Override
    protected void setup1(QueryFragmentContext ctx) {
        this.fetch.setup(ctx);
    }

    @Override
    protected IterationResult advance0() {
        RowBatch newBatch;
        boolean done;
        this.currentBatch = null;
        do {
            if (!this.state.advance()) {
                return IterationResult.WAIT;
            }
            RowBatch batch = this.state.consumeBatch();
            newBatch = this.fetch.apply(batch);
            boolean bl = done = this.fetch.isDone() || this.state.isDone();
        } while (!done && newBatch.getRowCount() <= 0);
        this.currentBatch = newBatch;
        return done ? IterationResult.FETCHED_DONE : IterationResult.FETCHED;
    }

    @Override
    protected RowBatch currentBatch0() {
        return this.currentBatch;
    }
}

