/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.internal.config.EntryListenerConfigReadOnly;
import com.hazelcast.internal.config.EventJournalConfigReadOnly;
import com.hazelcast.internal.config.EvictionConfigReadOnly;
import com.hazelcast.internal.config.HotRestartConfigReadOnly;
import com.hazelcast.internal.config.IndexConfigReadOnly;
import com.hazelcast.internal.config.MapPartitionLostListenerConfigReadOnly;
import com.hazelcast.internal.config.MapStoreConfigReadOnly;
import com.hazelcast.internal.config.MerkleTreeConfigReadOnly;
import com.hazelcast.internal.config.NearCacheConfigReadOnly;
import com.hazelcast.internal.config.PartitioningStrategyConfigReadOnly;
import com.hazelcast.internal.config.QueryCacheConfigReadOnly;
import com.hazelcast.internal.config.WanReplicationRefReadOnly;
import com.hazelcast.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class MapConfigReadOnly
extends MapConfig {
    private final EvictionConfigReadOnly evictionConfigReadOnly;
    private final WanReplicationRefReadOnly wanReplicationRefReadOnly;
    private final MapStoreConfigReadOnly mapStoreConfigReadOnly;
    private final NearCacheConfigReadOnly nearCacheConfigReadOnly;
    private final HotRestartConfigReadOnly hotRestartConfigReadOnly;
    private final EventJournalConfigReadOnly eventJournalConfigReadOnly;
    private final MerkleTreeConfigReadOnly merkleTreeConfigReadOnly;
    private final PartitioningStrategyConfigReadOnly partitioningStrategyConfigReadOnly;
    private final List<IndexConfig> indexConfigReadOnly;
    private final List<MapPartitionLostListenerConfig> partitionLostListenerConfigsReadOnly;
    private final List<QueryCacheConfig> queryCacheConfigsReadOnly;
    private final List<EntryListenerConfig> entryListenerConfigsReadOnly;

    public MapConfigReadOnly(MapConfig config) {
        super(config);
        EvictionConfig evictionConfig = super.getEvictionConfig();
        this.evictionConfigReadOnly = new EvictionConfigReadOnly(evictionConfig);
        WanReplicationRef wanReplicationRef = super.getWanReplicationRef();
        this.wanReplicationRefReadOnly = wanReplicationRef == null ? null : new WanReplicationRefReadOnly(wanReplicationRef);
        MapStoreConfig mapStoreConfig = super.getMapStoreConfig();
        this.mapStoreConfigReadOnly = mapStoreConfig == null ? null : new MapStoreConfigReadOnly(mapStoreConfig);
        NearCacheConfig nearCacheConfig = super.getNearCacheConfig();
        this.nearCacheConfigReadOnly = nearCacheConfig == null ? null : new NearCacheConfigReadOnly(nearCacheConfig);
        HotRestartConfig hotRestartConfig = super.getHotRestartConfig();
        this.hotRestartConfigReadOnly = new HotRestartConfigReadOnly(hotRestartConfig);
        EventJournalConfig eventJournalConfig = super.getEventJournalConfig();
        this.eventJournalConfigReadOnly = new EventJournalConfigReadOnly(eventJournalConfig);
        MerkleTreeConfig merkleTreeConfig = super.getMerkleTreeConfig();
        this.merkleTreeConfigReadOnly = new MerkleTreeConfigReadOnly(merkleTreeConfig);
        PartitioningStrategyConfig partitioningStrategyConfig = super.getPartitioningStrategyConfig();
        this.partitioningStrategyConfigReadOnly = partitioningStrategyConfig == null ? null : new PartitioningStrategyConfigReadOnly(partitioningStrategyConfig);
        this.indexConfigReadOnly = this.getIndexConfigReadOnly();
        this.partitionLostListenerConfigsReadOnly = this.getPartitionLostListenerConfigsReadOnly();
        this.queryCacheConfigsReadOnly = this.getQueryCacheConfigsReadOnly();
        this.entryListenerConfigsReadOnly = this.getEntryListenerConfigsReadOnly();
    }

    private List<EntryListenerConfig> getEntryListenerConfigsReadOnly() {
        List<EntryListenerConfig> entryListenerConfigs = super.getEntryListenerConfigs();
        if (CollectionUtil.isEmpty(entryListenerConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<EntryListenerConfigReadOnly> readOnlyEntryListenerConfigs = new ArrayList<EntryListenerConfigReadOnly>(entryListenerConfigs.size());
        for (EntryListenerConfig entryListenerConfig : entryListenerConfigs) {
            readOnlyEntryListenerConfigs.add(new EntryListenerConfigReadOnly(entryListenerConfig));
        }
        return Collections.unmodifiableList(readOnlyEntryListenerConfigs);
    }

    private List<QueryCacheConfig> getQueryCacheConfigsReadOnly() {
        List<QueryCacheConfig> queryCacheConfigs = super.getQueryCacheConfigs();
        if (CollectionUtil.isEmpty(queryCacheConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<QueryCacheConfigReadOnly> readOnlyOnes = new ArrayList<QueryCacheConfigReadOnly>(queryCacheConfigs.size());
        for (QueryCacheConfig queryCacheConfig : queryCacheConfigs) {
            readOnlyOnes.add(new QueryCacheConfigReadOnly(queryCacheConfig));
        }
        return Collections.unmodifiableList(readOnlyOnes);
    }

    private List<MapPartitionLostListenerConfig> getPartitionLostListenerConfigsReadOnly() {
        List<MapPartitionLostListenerConfig> listenerConfigs = super.getPartitionLostListenerConfigs();
        if (CollectionUtil.isEmpty(listenerConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<MapPartitionLostListenerConfigReadOnly> readOnlyListenerConfigs = new ArrayList<MapPartitionLostListenerConfigReadOnly>(listenerConfigs.size());
        for (MapPartitionLostListenerConfig listenerConfig : listenerConfigs) {
            readOnlyListenerConfigs.add(new MapPartitionLostListenerConfigReadOnly(listenerConfig));
        }
        return Collections.unmodifiableList(readOnlyListenerConfigs);
    }

    private List<IndexConfig> getIndexConfigReadOnly() {
        List<IndexConfig> indexConfigs = super.getIndexConfigs();
        if (CollectionUtil.isEmpty(indexConfigs)) {
            return Collections.emptyList();
        }
        ArrayList<IndexConfigReadOnly> readOnlyIndexConfigs = new ArrayList<IndexConfigReadOnly>(indexConfigs.size());
        for (IndexConfig indexConfig : indexConfigs) {
            readOnlyIndexConfigs.add(new IndexConfigReadOnly(indexConfig));
        }
        return Collections.unmodifiableList(readOnlyIndexConfigs);
    }

    @Override
    public EvictionConfig getEvictionConfig() {
        return this.evictionConfigReadOnly;
    }

    @Override
    public WanReplicationRef getWanReplicationRef() {
        return this.wanReplicationRefReadOnly;
    }

    @Override
    public List<EntryListenerConfig> getEntryListenerConfigs() {
        return this.entryListenerConfigsReadOnly;
    }

    @Override
    public List<MapPartitionLostListenerConfig> getPartitionLostListenerConfigs() {
        return this.partitionLostListenerConfigsReadOnly;
    }

    @Override
    public List<IndexConfig> getIndexConfigs() {
        return this.indexConfigReadOnly;
    }

    @Override
    public PartitioningStrategyConfig getPartitioningStrategyConfig() {
        return this.partitioningStrategyConfigReadOnly;
    }

    @Override
    public MapStoreConfig getMapStoreConfig() {
        return this.mapStoreConfigReadOnly;
    }

    @Override
    public NearCacheConfig getNearCacheConfig() {
        return this.nearCacheConfigReadOnly;
    }

    @Override
    public List<QueryCacheConfig> getQueryCacheConfigs() {
        return this.queryCacheConfigsReadOnly;
    }

    @Override
    @Nonnull
    public MerkleTreeConfig getMerkleTreeConfig() {
        return this.merkleTreeConfigReadOnly;
    }

    @Override
    @Nonnull
    public EventJournalConfig getEventJournalConfig() {
        return this.eventJournalConfigReadOnly;
    }

    @Override
    @Nonnull
    public HotRestartConfig getHotRestartConfig() {
        return this.hotRestartConfigReadOnly;
    }

    @Override
    public MapConfig setMerkleTreeConfig(@Nonnull MerkleTreeConfig merkleTreeConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setEventJournalConfig(@Nonnull EventJournalConfig eventJournalConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setHotRestartConfig(@Nonnull HotRestartConfig hotRestartConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setName(String name) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setBackupCount(int backupCount) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setAsyncBackupCount(int asyncBackupCount) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setMaxIdleSeconds(int maxIdleSeconds) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setEvictionConfig(EvictionConfig evictionConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setMapStoreConfig(MapStoreConfig mapStoreConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setNearCacheConfig(NearCacheConfig nearCacheConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setStatisticsEnabled(boolean statisticsEnabled) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setPerEntryStatsEnabled(boolean entryStatsEnabled) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setReadBackupData(boolean readBackupData) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setWanReplicationRef(WanReplicationRef wanReplicationRef) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig addEntryListenerConfig(EntryListenerConfig listenerConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setEntryListenerConfigs(List<EntryListenerConfig> listenerConfigs) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setPartitioningStrategyConfig(PartitioningStrategyConfig partitioningStrategyConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setPartitionLostListenerConfigs(List<MapPartitionLostListenerConfig> listenerConfigs) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setAttributeConfigs(List<AttributeConfig> attributeConfigs) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setQueryCacheConfigs(List<QueryCacheConfig> queryCacheConfigs) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setCacheDeserializedValues(CacheDeserializedValues cacheDeserializedValues) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig addIndexConfig(IndexConfig indexConfig) {
        throw this.throwReadOnly();
    }

    @Override
    public MapConfig setIndexConfigs(List<IndexConfig> indexConfigs) {
        throw this.throwReadOnly();
    }

    private UnsupportedOperationException throwReadOnly() {
        throw new UnsupportedOperationException("This config is read-only");
    }
}

