/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.spi.annotation.Beta;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@Beta
public class CompactSerializationConfig {
    private final Map<String, TriTuple<Class, String, CompactSerializer>> classNameToRegistryMap;
    private final Map<Class, TriTuple<Class, String, CompactSerializer>> classToRegistryMap;
    private boolean enabled;

    public CompactSerializationConfig() {
        this.classNameToRegistryMap = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>();
        this.classToRegistryMap = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>();
    }

    public CompactSerializationConfig(CompactSerializationConfig compactSerializationConfig) {
        this.classNameToRegistryMap = new ConcurrentHashMap<String, TriTuple<Class, String, CompactSerializer>>(compactSerializationConfig.classNameToRegistryMap);
        this.classToRegistryMap = new ConcurrentHashMap<Class, TriTuple<Class, String, CompactSerializer>>(compactSerializationConfig.classToRegistryMap);
        this.enabled = compactSerializationConfig.enabled;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        this.register0(clazz, clazz.getName(), null);
        return this;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz, String typeName) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        Preconditions.checkNotNull(typeName, "Type name cannot be null");
        this.register0(clazz, typeName, null);
        return this;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz, @Nonnull String typeName, @Nonnull CompactSerializer<T> explicitSerializer) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        Preconditions.checkNotNull(typeName, "Type name cannot be null");
        Preconditions.checkNotNull(explicitSerializer, "Explicit serializer cannot be null");
        this.register0(clazz, typeName, explicitSerializer);
        return this;
    }

    public <T> CompactSerializationConfig register(@Nonnull Class<T> clazz, @Nonnull CompactSerializer<T> explicitSerializer) {
        Preconditions.checkNotNull(clazz, "Class cannot be null");
        Preconditions.checkNotNull(explicitSerializer, "Explicit serializer cannot be null");
        this.register0(clazz, clazz.getName(), explicitSerializer);
        return this;
    }

    @Nonnull
    public Map<String, TriTuple<Class, String, CompactSerializer>> getRegistries() {
        return Collections.unmodifiableMap(this.classNameToRegistryMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactSerializationConfig that = (CompactSerializationConfig)o;
        return Objects.equals(this.classNameToRegistryMap, that.classNameToRegistryMap) && Objects.equals(this.classToRegistryMap, that.classToRegistryMap);
    }

    public int hashCode() {
        return Objects.hash(this.classNameToRegistryMap, this.classToRegistryMap);
    }

    private <T> void register0(Class<T> clazz, String typeName, CompactSerializer<T> explicitSerializer) {
        TriTuple<Class<T>, String, CompactSerializer<T>> registry = TriTuple.of(clazz, typeName, explicitSerializer);
        TriTuple<Class<T>, String, CompactSerializer<T>> oldRegistry = this.classNameToRegistryMap.putIfAbsent(typeName, registry);
        if (oldRegistry != null) {
            throw new InvalidConfigurationException("Already have a registry for the type name " + typeName);
        }
        oldRegistry = this.classToRegistryMap.putIfAbsent(clazz, registry);
        if (oldRegistry != null) {
            throw new InvalidConfigurationException("Already have a registry for class " + clazz);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CompactSerializationConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

