/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.RaftEndpointImpl;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.UUID;

public class CPMemberInfo
implements CPMember,
Serializable,
IdentifiedDataSerializable {
    private static final long serialVersionUID = 5628148969327743953L;
    private UUID uuid;
    private Address address;
    private transient RaftEndpointImpl endpoint;

    public CPMemberInfo() {
    }

    public CPMemberInfo(UUID uuid, Address address) {
        Preconditions.checkNotNull(uuid);
        Preconditions.checkNotNull(address);
        this.uuid = uuid;
        this.endpoint = new RaftEndpointImpl(uuid);
        this.address = address;
    }

    public CPMemberInfo(Member member) {
        this(member.getUuid(), member.getAddress());
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public RaftEndpoint toRaftEndpoint() {
        return this.endpoint;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeUTF(this.address.getHost());
        out.writeInt(this.address.getPort());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.endpoint = new RaftEndpointImpl(this.uuid);
        String host = in.readUTF();
        int port = in.readInt();
        this.address = new Address(host, port);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeObject(this.address);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.endpoint = new RaftEndpointImpl(this.uuid);
        this.address = (Address)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 31;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CPMemberInfo that = (CPMemberInfo)o;
        if (!this.uuid.equals(that.uuid)) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.uuid.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }

    public String toString() {
        return "CPMember{uuid=" + this.endpoint.getUuid() + ", address=" + this.address + '}';
    }
}

