/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Endpoint;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.JetCacheManager;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.Observable;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.operation.GetJobIdsOperation;
import com.hazelcast.jet.impl.util.ConcurrentMemoizingSupplier;
import com.hazelcast.jet.impl.util.JetConsoleLogHandler;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.sql.SqlService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HazelcastBootstrap {
    private static ConcurrentMemoizingSupplier<BootstrappedInstanceProxy> supplier;
    private static final ILogger LOGGER;
    private static final AtomicBoolean LOGGING_CONFIGURED;
    private static final int JOB_START_CHECK_INTERVAL_MILLIS = 1000;
    private static final EnumSet<JobStatus> STARTUP_STATUSES;

    private HazelcastBootstrap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void executeJar(@Nonnull Supplier<HazelcastInstance> supplierOfInstance, @Nonnull String jar, @Nullable String snapshotName, @Nullable String jobName, @Nullable String mainClass, @Nonnull List<String> args) throws Exception {
        if (supplier != null) {
            throw new IllegalStateException("Supplier of HazelcastInstance was already set. This method should not be called outside the Hazelcast command line.");
        }
        supplier = new ConcurrentMemoizingSupplier<BootstrappedInstanceProxy>(() -> new BootstrappedInstanceProxy((HazelcastInstance)supplierOfInstance.get(), jar, snapshotName, jobName));
        try (JarFile jarFile = new JarFile(jar);){
            URL jarUrl;
            URLClassLoader classLoader;
            Class<?> clazz;
            Method main;
            int mods;
            if (StringUtil.isNullOrEmpty(mainClass)) {
                if (jarFile.getManifest() == null) {
                    HazelcastBootstrap.error("No manifest file in " + jar + ". You can use the -c option to provide the main class.");
                }
                if ((mainClass = jarFile.getManifest().getMainAttributes().getValue("Main-Class")) == null) {
                    HazelcastBootstrap.error("No Main-Class found in manifest. You can use the -c option to provide the main class.");
                }
            }
            if (((mods = (main = (clazz = HazelcastBootstrap.loadMainClass(classLoader = AccessController.doPrivileged(() -> HazelcastBootstrap.lambda$executeJar$1(jarUrl = new URL("file:///" + jar))), mainClass)).getDeclaredMethod("main", String[].class)).getModifiers()) & 1) == 0 || (mods & 8) == 0) {
                HazelcastBootstrap.error("Class " + clazz.getName() + " has a main(String[] args) method which is not public static");
            }
            String[] jobArgs = args.toArray(new String[0]);
            main.invoke(null, new Object[]{jobArgs});
            HazelcastBootstrap.awaitJobsStarted();
        }
        finally {
            HazelcastInstance remembered = supplier.remembered();
            if (remembered != null) {
                try {
                    remembered.shutdown();
                }
                catch (Throwable t) {
                    System.err.println("Shutdown failed with:");
                    t.printStackTrace();
                }
            }
            supplier = null;
        }
    }

    private static void awaitJobsStarted() {
        List<Job> submittedJobs = ((BootstrappedJetProxy)supplier.get().getJet()).submittedJobs();
        int submittedCount = submittedJobs.size();
        if (submittedCount == 0) {
            System.out.println("The JAR didn't submit any jobs.");
            return;
        }
        int previousCount = -1;
        while (true) {
            Util.uncheckRun(() -> Thread.sleep(1000L));
            List startedJobs = submittedJobs.stream().filter(job -> !STARTUP_STATUSES.contains((Object)job.getStatus())).collect(Collectors.toList());
            submittedJobs = submittedJobs.stream().filter(job -> !startedJobs.contains(job)).collect(Collectors.toList());
            int remainingCount = submittedJobs.size();
            if (submittedJobs.isEmpty() && remainingCount == previousCount) break;
            if (remainingCount == previousCount) continue;
            for (Job job2 : startedJobs) {
                if (job2.getName() != null) {
                    System.out.println("Job '" + job2.getName() + "' submitted at " + Util.toLocalDateTime(job2.getSubmissionTime()) + " changed status to " + (Object)((Object)job2.getStatus()) + " at " + Util.toLocalDateTime(System.currentTimeMillis()) + ".");
                    continue;
                }
                System.out.println("Job '" + job2.getIdString() + "' submitted at " + Util.toLocalDateTime(job2.getSubmissionTime()) + " changed status to " + (Object)((Object)job2.getStatus()) + " at " + Util.toLocalDateTime(System.currentTimeMillis()) + ".");
            }
            if (remainingCount == 1) {
                System.out.println("A job is still starting...");
            } else if (remainingCount > 1) {
                System.out.format("%,d jobs are still starting...%n", remainingCount);
            }
            previousCount = remainingCount;
        }
    }

    private static Class<?> loadMainClass(ClassLoader classLoader, String mainClass) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(mainClass);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot find or load main class: " + mainClass);
            throw e;
        }
    }

    private static void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    @Nonnull
    public static synchronized HazelcastInstance getInstance() {
        if (supplier == null) {
            supplier = new ConcurrentMemoizingSupplier<BootstrappedInstanceProxy>(() -> new BootstrappedInstanceProxy(HazelcastBootstrap.createStandaloneInstance()));
        }
        return supplier.get();
    }

    private static HazelcastInstance createStandaloneInstance() {
        HazelcastBootstrap.configureLogging();
        LOGGER.info("Bootstrapped instance requested but application wasn't called from hazelcast submit script. Creating a standalone Hazelcast instance instead.");
        Config config = Config.load();
        config.setProperty("hazelcast.wait.seconds.before.join", "0");
        config.getAdvancedNetworkConfig().setEnabled(false);
        JoinConfig join = config.getNetworkConfig().getJoin();
        join.getAutoDetectionConfig().setEnabled(false);
        join.getMulticastConfig().setEnabled(false);
        join.getTcpIpConfig().setEnabled(false);
        join.getAwsConfig().setEnabled(false);
        join.getGcpConfig().setEnabled(false);
        join.getAzureConfig().setEnabled(false);
        join.getKubernetesConfig().setEnabled(false);
        join.getEurekaConfig().setEnabled(false);
        join.setDiscoveryConfig(new DiscoveryConfig());
        return Hazelcast.newHazelcastInstance(config);
    }

    public static void configureLogging() {
        if (LOGGING_CONFIGURED.compareAndSet(false, true)) {
            try {
                String loggingType = System.getProperty(ClusterProperty.LOGGING_TYPE.getName(), "jdk");
                if (loggingType.equals("jdk")) {
                    java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
                    for (Handler handler : rootLogger.getHandlers()) {
                        if (!(handler instanceof ConsoleHandler)) continue;
                        rootLogger.removeHandler(handler);
                        rootLogger.addHandler(new JetConsoleLogHandler());
                        rootLogger.setLevel(Level.INFO);
                        return;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error configuring java.util.logging for Hazelcast: " + e);
            }
        }
    }

    private static /* synthetic */ URLClassLoader lambda$executeJar$1(URL jarUrl) {
        return new URLClassLoader(new URL[]{jarUrl}, HazelcastBootstrap.class.getClassLoader());
    }

    static {
        LOGGER = Logger.getLogger(Hazelcast.class.getName());
        LOGGING_CONFIGURED = new AtomicBoolean(false);
        STARTUP_STATUSES = EnumSet.of(JobStatus.NOT_RUNNING, JobStatus.STARTING);
    }

    private static class BootstrappedJetProxy<M>
    extends AbstractJetInstance<M> {
        private final AbstractJetInstance<M> jet;
        private final String jar;
        private final String snapshotName;
        private final String jobName;
        private final Collection<Job> submittedJobs = new CopyOnWriteArrayList<Job>();

        BootstrappedJetProxy(@Nonnull JetService jet, @Nullable String jar, @Nullable String snapshotName, @Nullable String jobName) {
            super(((AbstractJetInstance)jet).getHazelcastInstance());
            this.jet = (AbstractJetInstance)jet;
            this.jar = jar;
            this.snapshotName = snapshotName;
            this.jobName = jobName;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.jet.getName();
        }

        @Override
        @Nonnull
        public HazelcastInstance getHazelcastInstance() {
            return this.jet.getHazelcastInstance();
        }

        @Override
        @Nonnull
        public Cluster getCluster() {
            return this.jet.getCluster();
        }

        @Override
        @Nonnull
        public JetConfig getConfig() {
            return this.jet.getConfig();
        }

        @Override
        @Nonnull
        public Job newJob(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
            return this.remember(this.jet.newJob(pipeline, this.updateJobConfig(config)));
        }

        @Override
        @Nonnull
        public Job newJob(@Nonnull DAG dag, @Nonnull JobConfig config) {
            return this.remember(this.jet.newJob(dag, this.updateJobConfig(config)));
        }

        @Override
        @Nonnull
        public Job newJobIfAbsent(@Nonnull Pipeline pipeline, @Nonnull JobConfig config) {
            return this.remember(this.jet.newJobIfAbsent(pipeline, this.updateJobConfig(config)));
        }

        @Override
        @Nonnull
        public Job newJobIfAbsent(@Nonnull DAG dag, @Nonnull JobConfig config) {
            return this.remember(this.jet.newJobIfAbsent(dag, this.updateJobConfig(config)));
        }

        List<Job> submittedJobs() {
            return new ArrayList<Job>(this.submittedJobs);
        }

        private Job remember(@Nonnull Job job) {
            this.submittedJobs.add(job);
            return job;
        }

        private JobConfig updateJobConfig(@Nonnull JobConfig config) {
            if (this.jar != null) {
                config.addJar(this.jar);
            }
            if (this.snapshotName != null) {
                config.setInitialSnapshotName(this.snapshotName);
            }
            if (this.jobName != null) {
                config.setName(this.jobName);
            }
            return config;
        }

        @Override
        @Nonnull
        public List<Job> getJobs(@Nonnull String name) {
            return this.jet.getJobs(name);
        }

        @Override
        @Nonnull
        public <K, V> IMap<K, V> getMap(@Nonnull String name) {
            return this.jet.getMap(name);
        }

        @Override
        @Nonnull
        public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
            return this.jet.getReplicatedMap(name);
        }

        @Override
        @Nonnull
        public JetCacheManager getCacheManager() {
            return this.jet.getCacheManager();
        }

        @Override
        @Nonnull
        public <E> IList<E> getList(@Nonnull String name) {
            return this.jet.getList(name);
        }

        @Override
        @Nonnull
        public <T> ITopic<T> getReliableTopic(@Nonnull String name) {
            return this.jet.getReliableTopic(name);
        }

        @Override
        @Nonnull
        public <T> Observable<T> getObservable(@Nonnull String name) {
            return this.jet.getObservable(name);
        }

        @Override
        public void shutdown() {
            this.jet.shutdown();
        }

        @Override
        public boolean existsDistributedObject(@Nonnull String serviceName, @Nonnull String objectName) {
            return this.jet.existsDistributedObject(serviceName, objectName);
        }

        @Override
        public ILogger getLogger() {
            return this.jet.getLogger();
        }

        @Override
        public Job newJobProxy(long jobId, M lightJobCoordinator) {
            return this.jet.newJobProxy(jobId, lightJobCoordinator);
        }

        @Override
        public Job newJobProxy(long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config) {
            return this.jet.newJobProxy(jobId, isLightJob, jobDefinition, config);
        }

        @Override
        public M getMasterId() {
            return this.jet.getMasterId();
        }

        @Override
        public Map<M, GetJobIdsOperation.GetJobIdsResult> getJobsInt(String onlyName, Long onlyJobId) {
            return this.jet.getJobsInt(onlyName, onlyJobId);
        }
    }

    private static class BootstrappedInstanceProxy
    implements HazelcastInstance {
        private final HazelcastInstance instance;
        private final JetService jetProxy;

        BootstrappedInstanceProxy(@Nonnull HazelcastInstance instance) {
            this(instance, null, null, null);
        }

        BootstrappedInstanceProxy(@Nonnull HazelcastInstance instance, @Nullable String jar, @Nullable String snapshotName, @Nullable String jobName) {
            this.instance = instance;
            this.jetProxy = new BootstrappedJetProxy(instance.getJet(), jar, snapshotName, jobName);
        }

        @Override
        @Nonnull
        public String getName() {
            return this.instance.getName();
        }

        @Override
        @Nonnull
        public <K, V> IMap<K, V> getMap(@Nonnull String name) {
            return this.instance.getMap(name);
        }

        @Override
        @Nonnull
        public <E> IQueue<E> getQueue(@Nonnull String name) {
            return this.instance.getQueue(name);
        }

        @Override
        @Nonnull
        public <E> ITopic<E> getTopic(@Nonnull String name) {
            return this.instance.getTopic(name);
        }

        @Override
        @Nonnull
        public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
            return this.instance.getReliableTopic(name);
        }

        @Override
        @Nonnull
        public <E> ISet<E> getSet(@Nonnull String name) {
            return this.instance.getSet(name);
        }

        @Override
        @Nonnull
        public <E> IList<E> getList(@Nonnull String name) {
            return this.instance.getList(name);
        }

        @Override
        @Nonnull
        public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
            return this.instance.getMultiMap(name);
        }

        @Override
        @Nonnull
        public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
            return this.instance.getRingbuffer(name);
        }

        @Override
        @Nonnull
        public IExecutorService getExecutorService(@Nonnull String name) {
            return this.instance.getExecutorService(name);
        }

        @Override
        @Nonnull
        public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
            return this.instance.getDurableExecutorService(name);
        }

        @Override
        public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
            return this.instance.executeTransaction(task);
        }

        @Override
        public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
            return this.instance.executeTransaction(options, task);
        }

        @Override
        public TransactionContext newTransactionContext() {
            return this.instance.newTransactionContext();
        }

        @Override
        public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
            return this.instance.newTransactionContext(options);
        }

        @Override
        @Nonnull
        public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
            return this.instance.getFlakeIdGenerator(name);
        }

        @Override
        @Nonnull
        public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
            return this.instance.getReplicatedMap(name);
        }

        @Override
        public ICacheManager getCacheManager() {
            return this.instance.getCacheManager();
        }

        @Override
        @Nonnull
        public Cluster getCluster() {
            return this.instance.getCluster();
        }

        @Override
        @Nonnull
        public Endpoint getLocalEndpoint() {
            return this.instance.getLocalEndpoint();
        }

        @Override
        public Collection<DistributedObject> getDistributedObjects() {
            return this.instance.getDistributedObjects();
        }

        @Override
        @Nonnull
        public Config getConfig() {
            return this.instance.getConfig();
        }

        @Override
        @Nonnull
        public PartitionService getPartitionService() {
            return this.instance.getPartitionService();
        }

        @Override
        @Nonnull
        public SplitBrainProtectionService getSplitBrainProtectionService() {
            return this.instance.getSplitBrainProtectionService();
        }

        @Override
        @Nonnull
        public ClientService getClientService() {
            return this.instance.getClientService();
        }

        @Override
        @Nonnull
        public LoggingService getLoggingService() {
            return this.instance.getLoggingService();
        }

        @Override
        @Nonnull
        public LifecycleService getLifecycleService() {
            return this.instance.getLifecycleService();
        }

        @Override
        @Nonnull
        public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
            return this.instance.getDistributedObject(serviceName, name);
        }

        @Override
        public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
            return this.instance.addDistributedObjectListener(distributedObjectListener);
        }

        @Override
        public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
            return this.instance.removeDistributedObjectListener(registrationId);
        }

        @Override
        @Nonnull
        public ConcurrentMap<String, Object> getUserContext() {
            return this.instance.getUserContext();
        }

        @Override
        @Nonnull
        public HazelcastXAResource getXAResource() {
            return this.instance.getXAResource();
        }

        @Override
        @Nonnull
        public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
            return this.instance.getCardinalityEstimator(name);
        }

        @Override
        @Nonnull
        public PNCounter getPNCounter(@Nonnull String name) {
            return this.instance.getPNCounter(name);
        }

        @Override
        @Nonnull
        public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
            return this.instance.getScheduledExecutorService(name);
        }

        @Override
        @Nonnull
        public CPSubsystem getCPSubsystem() {
            return this.instance.getCPSubsystem();
        }

        @Override
        @Nonnull
        public SqlService getSql() {
            return this.instance.getSql();
        }

        @Override
        @Nonnull
        public JetService getJet() {
            return this.jetProxy;
        }

        @Override
        public void shutdown() {
            this.getLifecycleService().shutdown();
        }
    }
}

