/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.operation.PrepareForPassiveClusterOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.version.Version;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class JetExtension {
    private final Node node;
    private final ILogger logger;
    private final JetServiceBackend jetServiceBackend;
    private volatile boolean activated;
    private volatile boolean isAfterStartCalled;

    public JetExtension(Node node, JetServiceBackend jetServiceBackend) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        this.jetServiceBackend = jetServiceBackend;
        this.activated = false;
        this.isAfterStartCalled = false;
    }

    private void checkLosslessRestartAllowed() {
        Config config = this.node.config.getStaticConfig();
        JetConfig jetConfig = config.getJetConfig();
        if (jetConfig.getInstanceConfig().isLosslessRestartEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("Lossless Restart requires Hazelcast Enterprise Edition");
        }
    }

    public void beforeStart() {
        this.jetServiceBackend.configureJetInternalObjects(this.node.config.getStaticConfig(), this.node.getProperties());
        this.checkLosslessRestartAllowed();
    }

    public void afterStart() {
        if (this.node.isRunning() && this.node.getClusterService().getClusterVersion().isGreaterOrEqual(Versions.V5_0)) {
            this.activated = true;
            this.jetServiceBackend.getJobCoordinationService().startScanningForJobs();
            this.logger.info("Jet is enabled");
        } else {
            this.logger.info("Jet is disabled due to current cluster version being less than 5.0.");
        }
        this.isAfterStartCalled = true;
    }

    public void beforeClusterStateChange(ClusterState requestedState) {
        if (!this.activated || requestedState != ClusterState.PASSIVE) {
            return;
        }
        this.logger.info("Jet is preparing to enter the PASSIVE cluster state");
        NodeEngineImpl ne = this.node.nodeEngine;
        try {
            ne.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)new PrepareForPassiveClusterOperation(), ne.getMasterAddress()).invoke().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public void onClusterStateChange(ClusterState ignored) {
        if (this.activated) {
            this.jetServiceBackend.getJobCoordinationService().clusterChangeDone();
        }
    }

    public void onClusterVersionChange(Version newVersion) {
        if (!this.activated && this.isAfterStartCalled && newVersion.isGreaterOrEqual(Versions.V5_0)) {
            this.activated = true;
            this.jetServiceBackend.getJobCoordinationService().startScanningForJobs();
            this.logger.info("Jet is enabled after the cluster version upgrade.");
        }
    }

    public void beforeShutdown(boolean terminate) {
        if (!terminate && this.activated) {
            this.jetServiceBackend.shutDownJobs();
        }
    }

    public void handlePacket(Packet packet) {
        this.jetServiceBackend.handlePacket(packet);
    }

    public Map<String, Object> createExtensionServices() {
        HashMap<String, Object> extensionServices = new HashMap<String, Object>();
        extensionServices.put("hz:impl:jetService", this.jetServiceBackend);
        if (this.jetServiceBackend.getSqlCoreBackend() != null) {
            extensionServices.put("hz:impl:jetSqlCoreBackend", this.jetServiceBackend.getSqlCoreBackend());
        }
        return extensionServices;
    }

    public JetService getJet() {
        if (this.activated) {
            return this.jetServiceBackend.getJet();
        }
        throw new IllegalArgumentException("Jet is disabled because the current cluster version is less than 5.0");
    }
}

