/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.DataPersistenceConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public final class DataPersistenceAndHotRestartMerger {
    private static final ILogger LOGGER = Logger.getLogger(DataPersistenceAndHotRestartMerger.class);

    private DataPersistenceAndHotRestartMerger() {
    }

    public static void merge(HotRestartConfig hotRestartConfig, DataPersistenceConfig dataPersistenceConfig) {
        if (hotRestartConfig.isEnabled() && !dataPersistenceConfig.isEnabled()) {
            dataPersistenceConfig.setEnabled(true).setFsync(hotRestartConfig.isFsync());
            return;
        }
        boolean override = hotRestartConfig.isEnabled() && dataPersistenceConfig.isEnabled();
        hotRestartConfig.setEnabled(dataPersistenceConfig.isEnabled()).setFsync(dataPersistenceConfig.isFsync());
        if (override) {
            LOGGER.warning("Please note that HotRestart is deprecated and should not be used. Since both HotRestart and DataPersistence are enabled, and thus there is a conflict, the latter is used in persistence configuration.");
        }
    }
}

