/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.SchemaViolationConfigurationException;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlToJsonConverter;
import com.hazelcast.org.everit.json.schema.Schema;
import com.hazelcast.org.everit.json.schema.ValidationException;
import com.hazelcast.org.everit.json.schema.loader.SchemaLoader;
import com.hazelcast.org.json.JSONObject;
import com.hazelcast.org.json.JSONTokener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class YamlConfigSchemaValidator {
    private static final List<String> PERMITTED_ROOT_NODES = Collections.unmodifiableList(Arrays.asList("hazelcast", "hazelcast-client", "hazelcast-client-failover"));
    private static final Schema SCHEMA = SchemaLoader.builder().draftV6Support().schemaJson(YamlConfigSchemaValidator.readJSONObject("/hazelcast-config-" + Versions.CURRENT_CLUSTER_VERSION.getMajor() + "." + Versions.CURRENT_CLUSTER_VERSION.getMinor() + ".json")).build().load().build();

    SchemaViolationConfigurationException wrap(ValidationException e) {
        List<SchemaViolationConfigurationException> subErrors = e.getCausingExceptions().stream().map(this::wrap).collect(Collectors.toList());
        return new SchemaViolationConfigurationException(e.getErrorMessage(), e.getSchemaLocation(), e.getPointerToViolation(), subErrors);
    }

    private static JSONObject readJSONObject(String absPath) {
        return new JSONObject(new JSONTokener(YamlConfigSchemaValidator.class.getResourceAsStream(absPath)));
    }

    public void validate(YamlMapping rootNode) {
        try {
            long definedRootNodeCount = PERMITTED_ROOT_NODES.stream().filter(rootNodeName -> rootNode.child((String)rootNodeName) != null).count();
            if (definedRootNodeCount != 1L) {
                throw new SchemaViolationConfigurationException("exactly one of [hazelcast], [hazelcast-client] and [hazelcast-client-failover] should be present in the root schema document, " + definedRootNodeCount + " are present", "#", "#", Collections.emptyList());
            }
            SCHEMA.validate(YamlToJsonConverter.convert(rootNode));
        }
        catch (ValidationException e) {
            throw this.wrap(e);
        }
    }
}

