/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionStampUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

public class PartitionTableView {
    private final InternalPartition[] partitions;
    private long stamp;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PartitionTableView(InternalPartition[] partitions) {
        this.partitions = partitions;
    }

    public long stamp() {
        long s = this.stamp;
        if (s == 0L) {
            this.stamp = s = PartitionStampUtil.calculateStamp(this.partitions);
        }
        return s;
    }

    public int length() {
        return this.partitions.length;
    }

    public InternalPartition getPartition(int partitionId) {
        return this.partitions[partitionId];
    }

    public PartitionReplica getReplica(int partitionId, int replicaIndex) {
        InternalPartition partition = this.partitions[partitionId];
        return partition != null ? partition.getReplica(replicaIndex) : null;
    }

    public PartitionReplica[] getReplicas(int partitionId) {
        InternalPartition partition = this.partitions[partitionId];
        return partition != null ? partition.getReplicasCopy() : new PartitionReplica[7];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionTableView that = (PartitionTableView)o;
        return Arrays.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.partitions);
    }

    public String toString() {
        return "PartitionTableView{partitions=" + Arrays.toString(this.partitions) + ", stamp=" + this.stamp() + '}';
    }
}

