/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.PartitionReplicaSyncRequest;
import com.hazelcast.internal.partition.operation.UrgentPartitionRunnable;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class PartitionReplicaSyncRequestOffloadable
extends PartitionReplicaSyncRequest {
    private volatile int partitionId;

    public PartitionReplicaSyncRequestOffloadable() {
        this.namespaces = Collections.emptyList();
    }

    public PartitionReplicaSyncRequestOffloadable(int partitionId, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        this.namespaces = Collections.newSetFromMap(new ConcurrentHashMap());
        this.namespaces.addAll(namespaces);
        this.partitionId = partitionId;
        this.setPartitionId(-1);
        this.setReplicaIndex(replicaIndex);
    }

    @Override
    public CallStatus call() throws Exception {
        return new ReplicaSyncRequestOffload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendOperationsForNamespaces(int permits) {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        try {
            PartitionReplicationEvent event = new PartitionReplicationEvent(this.getCallerAddress(), this.partitionId, this.getReplicaIndex());
            Iterator iterator = this.namespaces.iterator();
            for (int i = 0; i < permits; ++i) {
                ServiceNamespace namespace = (ServiceNamespace)iterator.next();
                Collection<Operation> operations = null;
                operations = NonFragmentedServiceNamespace.INSTANCE.equals(namespace) ? this.createNonFragmentedReplicationOperations(event) : this.createFragmentReplicationOperationsOffload(event, namespace);
                if (operations == null) continue;
                operations = new CopyOnWriteArrayList<Operation>(operations);
                this.sendOperationsOnPartitionThread(operations, namespace);
                iterator.remove();
            }
        }
        finally {
            partitionService.getReplicaManager().releaseReplicaSyncPermits(permits);
        }
    }

    @Override
    protected int partitionId() {
        return this.partitionId;
    }

    private void sendOperationsOnPartitionThread(Collection<Operation> operations, ServiceNamespace ns) {
        if (ThreadUtil.isRunningOnPartitionThread()) {
            this.sendOperations(operations, ns);
        } else {
            UrgentPartitionRunnable partitionRunnable = new UrgentPartitionRunnable(this.partitionId(), () -> this.sendOperations(operations, ns));
            this.getNodeEngine().getOperationService().execute(partitionRunnable);
            partitionRunnable.future.joinInternal();
        }
    }

    @Override
    public int getClassId() {
        return 25;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeCollection(this.namespaces, out);
        out.writeInt(this.partitionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.namespaces = Collections.newSetFromMap(new ConcurrentHashMap());
        this.namespaces.addAll(SerializationUtil.readCollection(in));
        this.partitionId = in.readInt();
    }

    final class ReplicaSyncRequestOffload
    extends Offload {
        ReplicaSyncRequestOffload() {
            super(PartitionReplicaSyncRequestOffloadable.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() throws Exception {
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)PartitionReplicaSyncRequestOffloadable.this.getService();
            PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
            if (!partitionStateManager.trySetMigratingFlag(PartitionReplicaSyncRequestOffloadable.this.partitionId) && !partitionStateManager.isMigrating(PartitionReplicaSyncRequestOffloadable.this.partitionId)) {
                throw new RetryableHazelcastException("Cannot set migrating flag, probably previous migration's finalization is not completed yet.");
            }
            try {
                Integer permits = PartitionReplicaSyncRequestOffloadable.this.getPermits();
                if (permits == null) {
                    return;
                }
                PartitionReplicaSyncRequestOffloadable.this.sendOperationsForNamespaces(permits);
                if (!PartitionReplicaSyncRequestOffloadable.this.namespaces.isEmpty()) {
                    PartitionReplicaSyncRequestOffloadable.this.logNotEnoughPermits();
                    PartitionReplicaSyncRequestOffloadable.this.sendRetryResponse();
                }
            }
            finally {
                partitionStateManager.clearMigratingFlag(PartitionReplicaSyncRequestOffloadable.this.partitionId);
            }
        }
    }
}

