/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.serialization.impl.compact.AbstractGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class DeserializedGenericRecordCloner
extends AbstractGenericRecordBuilder {
    private final TreeMap<String, Object> objects;
    private final Schema schema;
    private final Set<String> overwrittenFields = new HashSet<String>();

    public DeserializedGenericRecordCloner(Schema schema, TreeMap<String, Object> objects) {
        this.objects = objects;
        this.schema = schema;
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        return new DeserializedGenericRecord(this.schema, this.objects);
    }

    @Override
    protected GenericRecordBuilder write(@Nonnull String fieldName, Object value, FieldType fieldType) {
        DeserializedGenericRecordCloner.checkTypeWithSchema(this.schema, fieldName, fieldType);
        if (!this.overwrittenFields.add(fieldName)) {
            throw new HazelcastSerializationException("Field can only be written once");
        }
        this.objects.put(fieldName, value);
        return this;
    }
}

