/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ReflectiveCompactSerializer
implements CompactSerializer<Object> {
    private final Map<Class, Writer[]> writersCache = new ConcurrentHashMap<Class, Writer[]>();
    private final Map<Class, Reader[]> readersCache = new ConcurrentHashMap<Class, Reader[]>();

    @Override
    public void write(@Nonnull CompactWriter writer, @Nonnull Object object) throws IOException {
        Class<?> clazz = object.getClass();
        if (this.writeFast(clazz, writer, object)) {
            return;
        }
        this.createFastReadWriteCaches(clazz);
        this.writeFast(clazz, writer, object);
    }

    private boolean writeFast(Class clazz, CompactWriter compactWriter, Object object) throws IOException {
        Writer[] writers = this.writersCache.get(clazz);
        if (writers == null) {
            return false;
        }
        for (Writer writer : writers) {
            try {
                writer.write(compactWriter, object);
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e, IOException.class);
            }
        }
        return true;
    }

    private boolean readFast(Class clazz, DefaultCompactReader compactReader, Object object) throws IOException {
        Reader[] readers = this.readersCache.get(clazz);
        Schema schema = compactReader.getSchema();
        if (readers == null) {
            return false;
        }
        for (Reader reader : readers) {
            try {
                reader.read(compactReader, schema, object);
            }
            catch (Exception e) {
                ExceptionUtil.rethrow((Throwable)e, IOException.class);
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public Object read(@Nonnull CompactReader reader) throws IOException {
        DefaultCompactReader compactReader = (DefaultCompactReader)reader;
        Class associatedClass = compactReader.getAssociatedClass();
        Object object = this.createObject(associatedClass);
        try {
            if (this.readFast(associatedClass, compactReader, object)) {
                return object;
            }
            this.createFastReadWriteCaches(associatedClass);
            this.readFast(associatedClass, compactReader, object);
            return object;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Nonnull
    private Object createObject(Class associatedClass) {
        try {
            return ClassLoaderUtil.newInstance(associatedClass.getClassLoader(), associatedClass);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Could not construct the class " + associatedClass, e);
        }
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.stream(type.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList()));
        if (type.getSuperclass() != null && type.getSuperclass() != Object.class) {
            ReflectiveCompactSerializer.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    private boolean fieldExists(Schema schema, String name, FieldType fieldType) {
        FieldDescriptor fieldDescriptor = schema.getField(name);
        return fieldDescriptor != null && fieldDescriptor.getType().equals((Object)fieldType);
    }

    private void createFastReadWriteCaches(Class clazz) throws IOException {
        this.createObject(clazz);
        List<Field> allFields = ReflectiveCompactSerializer.getAllFields(new LinkedList<Field>(), clazz);
        Writer[] writers = new Writer[allFields.size()];
        Reader[] readers = new Reader[allFields.size()];
        int index = 0;
        for (Field field : allFields) {
            field.setAccessible(true);
            Class<?> type = field.getType();
            String name = field.getName();
            if (Byte.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.BYTE)) {
                        field.setByte(o, reader.readByte(name));
                    }
                };
                writers[index] = (w, o) -> w.writeByte(name, field.getByte(o));
            } else if (Short.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.SHORT)) {
                        field.setShort(o, reader.readShort(name));
                    }
                };
                writers[index] = (w, o) -> w.writeShort(name, field.getShort(o));
            } else if (Integer.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.INT)) {
                        field.setInt(o, reader.readInt(name));
                    }
                };
                writers[index] = (w, o) -> w.writeInt(name, field.getInt(o));
            } else if (Long.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.LONG)) {
                        field.setLong(o, reader.readLong(name));
                    }
                };
                writers[index] = (w, o) -> w.writeLong(name, field.getLong(o));
            } else if (Float.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.FLOAT)) {
                        field.setFloat(o, reader.readFloat(name));
                    }
                };
                writers[index] = (w, o) -> w.writeFloat(name, field.getFloat(o));
            } else if (Double.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.DOUBLE)) {
                        field.setDouble(o, reader.readDouble(name));
                    }
                };
                writers[index] = (w, o) -> w.writeDouble(name, field.getDouble(o));
            } else if (Boolean.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.BOOLEAN)) {
                        field.setBoolean(o, reader.readBoolean(name));
                    }
                };
                writers[index] = (w, o) -> w.writeBoolean(name, field.getBoolean(o));
            } else if (Character.TYPE.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.CHAR)) {
                        field.setChar(o, reader.readChar(name));
                    }
                };
                writers[index] = (w, o) -> w.writeChar(name, field.getChar(o));
            } else if (String.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.UTF)) {
                        field.set(o, reader.readString(name));
                    }
                };
                writers[index] = (w, o) -> w.writeString(name, (String)field.get(o));
            } else if (BigDecimal.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.DECIMAL)) {
                        field.set(o, reader.readDecimal(name));
                    }
                };
                writers[index] = (w, o) -> w.writeDecimal(name, (BigDecimal)field.get(o));
            } else if (LocalTime.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.TIME)) {
                        field.set(o, reader.readTime(name));
                    }
                };
                writers[index] = (w, o) -> w.writeTime(name, (LocalTime)field.get(o));
            } else if (LocalDate.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.DATE)) {
                        field.set(o, reader.readDate(name));
                    }
                };
                writers[index] = (w, o) -> w.writeDate(name, (LocalDate)field.get(o));
            } else if (LocalDateTime.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.TIMESTAMP)) {
                        field.set(o, reader.readTimestamp(name));
                    }
                };
                writers[index] = (w, o) -> w.writeTimestamp(name, (LocalDateTime)field.get(o));
            } else if (OffsetDateTime.class.equals(type)) {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.TIMESTAMP_WITH_TIMEZONE)) {
                        field.set(o, reader.readTimestampWithTimezone(name));
                    }
                };
                writers[index] = (w, o) -> w.writeTimestampWithTimezone(name, (OffsetDateTime)field.get(o));
            } else if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (Byte.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.BYTE_ARRAY)) {
                            field.set(o, reader.readByteArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeByteArray(name, (byte[])field.get(o));
                } else if (Short.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.SHORT_ARRAY)) {
                            field.set(o, reader.readShortArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeShortArray(name, (short[])field.get(o));
                } else if (Integer.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.INT_ARRAY)) {
                            field.set(o, reader.readIntArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeIntArray(name, (int[])field.get(o));
                } else if (Long.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.LONG_ARRAY)) {
                            field.set(o, reader.readLongArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeLongArray(name, (long[])field.get(o));
                } else if (Float.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.FLOAT_ARRAY)) {
                            field.set(o, reader.readFloatArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeFloatArray(name, (float[])field.get(o));
                } else if (Double.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.DOUBLE_ARRAY)) {
                            field.set(o, reader.readDoubleArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeDoubleArray(name, (double[])field.get(o));
                } else if (Boolean.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.BOOLEAN_ARRAY)) {
                            field.set(o, reader.readBooleanArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeBooleanArray(name, (boolean[])field.get(o));
                } else if (Character.TYPE.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.CHAR_ARRAY)) {
                            field.set(o, reader.readCharArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeCharArray(name, (char[])field.get(o));
                } else if (String.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.UTF_ARRAY)) {
                            field.set(o, reader.readStringArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeStringArray(name, (String[])field.get(o));
                } else if (BigDecimal.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.DECIMAL_ARRAY)) {
                            field.set(o, reader.readDecimalArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeDecimalArray(name, (BigDecimal[])field.get(o));
                } else if (LocalTime.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.TIME_ARRAY)) {
                            field.set(o, reader.readTimeArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeTimeArray(name, (LocalTime[])field.get(o));
                } else if (LocalDate.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.DATE_ARRAY)) {
                            field.set(o, reader.readDateArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeDateArray(name, (LocalDate[])field.get(o));
                } else if (LocalDateTime.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.TIMESTAMP_ARRAY)) {
                            field.set(o, reader.readTimestampArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeTimestampArray(name, (LocalDateTime[])field.get(o));
                } else if (OffsetDateTime.class.equals(componentType)) {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY)) {
                            field.set(o, reader.readTimestampWithTimezoneArray(name));
                        }
                    };
                    writers[index] = (w, o) -> w.writeTimestampWithTimezoneArray(name, (OffsetDateTime[])field.get(o));
                } else {
                    readers[index] = (reader, schema, o) -> {
                        if (this.fieldExists(schema, name, FieldType.COMPOSED_ARRAY)) {
                            field.set(o, reader.readObjectArray(name, componentType));
                        }
                    };
                    writers[index] = (w, o) -> w.writeObjectArray(name, (Object[])field.get(o));
                }
            } else {
                readers[index] = (reader, schema, o) -> {
                    if (this.fieldExists(schema, name, FieldType.COMPOSED)) {
                        field.set(o, reader.readObject(name));
                    }
                };
                writers[index] = (w, o) -> w.writeObject(name, field.get(o));
            }
            ++index;
        }
        this.writersCache.put(clazz, writers);
        this.readersCache.put(clazz, readers);
    }

    static interface Writer {
        public void write(CompactWriter var1, Object var2) throws Exception;
    }

    static interface Reader {
        public void read(CompactReader var1, Schema var2, Object var3) throws Exception;
    }
}

