/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.nio.ConnectionLifecycleListener;
import com.hazelcast.internal.nio.ConnectionType;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.TcpServerConnectionErrorHandler;
import com.hazelcast.internal.server.tcp.TcpServerConnectionManager;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class TcpServerConnection
implements ServerConnection {
    private final Channel channel;
    private final ConcurrentMap attributeMap;
    private final TcpServerConnectionManager connectionManager;
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private final AtomicBoolean handshake = new AtomicBoolean();
    private final ILogger logger;
    private final int connectionId;
    private final ServerContext serverContext;
    private Address remoteAddress;
    private TcpServerConnectionErrorHandler errorHandler;
    private volatile String connectionType = "NONE";
    private volatile ConnectionLifecycleListener<TcpServerConnection> lifecycleListener;
    private volatile Throwable closeCause;
    private volatile String closeReason;
    private volatile int planeIndex = -1;

    public TcpServerConnection(TcpServerConnectionManager connectionManager, ConnectionLifecycleListener<TcpServerConnection> lifecycleListener, int connectionId, Channel channel) {
        this.connectionId = connectionId;
        this.connectionManager = connectionManager;
        this.lifecycleListener = lifecycleListener;
        this.serverContext = connectionManager.getServer().getContext();
        this.logger = this.serverContext.getLoggingService().getLogger(TcpServerConnection.class);
        this.channel = channel;
        this.attributeMap = channel.attributeMap();
        this.attributeMap.put(ServerConnection.class, this);
    }

    @Override
    public ConcurrentMap attributeMap() {
        return this.attributeMap;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getPlaneIndex() {
        return this.planeIndex;
    }

    public void setPlaneIndex(int planeIndex) {
        this.planeIndex = planeIndex;
    }

    @Override
    public String getConnectionType() {
        return this.connectionType;
    }

    @Probe(name="connectionType", unit=ProbeUnit.ENUM)
    private int getType() {
        return ConnectionType.getTypeId(this.connectionType);
    }

    @Override
    public void setConnectionType(String connectionType) {
        Objects.requireNonNull(connectionType);
        if (!this.connectionType.equals("NONE")) {
            return;
        }
        this.connectionType = connectionType;
        if (connectionType.equals("MEMBER")) {
            this.logger.info("Initialized new cluster connection between " + this.channel.localSocketAddress() + " and " + this.channel.remoteSocketAddress());
        }
    }

    @Override
    public TcpServerConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.channel.remoteSocketAddress();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.channel.socket().getInetAddress();
    }

    @Override
    public boolean isAlive() {
        return this.alive.get();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.channel.lastWriteTimeMillis();
    }

    @Override
    public long lastReadTimeMillis() {
        return this.channel.lastReadTimeMillis();
    }

    @Override
    public Address getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void setRemoteAddress(Address remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setErrorHandler(TcpServerConnectionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    @Override
    public boolean isClient() {
        return !this.connectionType.equals("MEMBER");
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.channel.write(frame)) {
            return true;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Connection is closed, won't write packet -> " + frame);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpServerConnection)) {
            return false;
        }
        TcpServerConnection that = (TcpServerConnection)o;
        return this.connectionId == that.getConnectionId();
    }

    public int hashCode() {
        return this.connectionId;
    }

    @Override
    public void close(String reason, Throwable cause) {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        this.serverContext.getAuditLogService().eventBuilder("HZ-0102").message("Closing server connection.").addParameter("reason", reason).addParameter("cause", cause).addParameter("remoteAddress", this.remoteAddress).log();
        this.logClose();
        try {
            this.channel.close();
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        this.lifecycleListener.onConnectionClose(this, cause, false);
        this.serverContext.onDisconnect(this.remoteAddress, cause);
        LoginContext lc = (LoginContext)this.attributeMap.remove(LoginContext.class);
        if (lc != null) {
            try {
                lc.logout();
            }
            catch (LoginException e) {
                this.logger.warning("Logout failed", e);
            }
        }
        if (cause != null && this.errorHandler != null) {
            this.errorHandler.onError(cause);
        }
    }

    public boolean setHandshake() {
        return this.handshake.compareAndSet(false, true);
    }

    private void logClose() {
        Level logLevel = this.resolveLogLevelOnClose();
        if (!this.logger.isLoggable(logLevel)) {
            return;
        }
        String message = this.toString() + " closed. Reason: ";
        message = this.closeReason != null ? message + this.closeReason : (this.closeCause != null ? message + this.closeCause.getClass().getName() + "[" + this.closeCause.getMessage() + "]" : message + "Socket explicitly closed");
        if (Level.FINEST.equals(logLevel)) {
            this.logger.log(logLevel, message, this.closeCause);
        } else if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
            this.logger.log(logLevel, message);
        } else {
            this.logger.log(logLevel, message, this.closeCause);
        }
    }

    private Level resolveLogLevelOnClose() {
        if (!this.serverContext.isNodeActive()) {
            return Level.FINEST;
        }
        if (this.closeCause == null || this.closeCause instanceof EOFException || this.closeCause instanceof CancelledKeyException) {
            if (this.connectionType.equals("REST") || this.connectionType.equals("MEMCACHE")) {
                return Level.FINE;
            }
            return Level.INFO;
        }
        return Level.WARNING;
    }

    @Override
    public Throwable getCloseCause() {
        return this.closeCause;
    }

    @Override
    public String getCloseReason() {
        if (this.closeReason == null) {
            return this.closeCause == null ? null : this.closeCause.getMessage();
        }
        return this.closeReason;
    }

    public String toString() {
        return "Connection[id=" + this.connectionId + ", " + this.channel.localSocketAddress() + "->" + this.channel.remoteSocketAddress() + ", qualifier=" + this.connectionManager.getEndpointQualifier() + ", endpoint=" + this.remoteAddress + ", alive=" + this.alive + ", connectionType=" + this.connectionType + ", planeIndex=" + this.planeIndex + "]";
    }
}

