/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.nio.ConnectionLifecycleListener;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.server.NetworkStats;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerConnectionManager;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.TcpServer;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.server.tcp.TcpServerConnectionErrorHandler;
import com.hazelcast.internal.server.tcp.TcpServerConnectionManager;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.MutableLong;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.internal.util.executor.StripedRunnable;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

abstract class TcpServerConnectionManagerBase
implements ServerConnectionManager {
    private static final int RETRY_NUMBER = 5;
    private static final long DELAY_FACTOR = 100L;
    @Probe(name="openedCount")
    protected final MwCounter openedCount = MwCounter.newMwCounter();
    @Probe(name="closedCount")
    protected final MwCounter closedCount = MwCounter.newMwCounter();
    protected final ILogger logger;
    protected final TcpServer server;
    protected final ServerContext serverContext;
    protected final NetworkStatsImpl networkStats;
    protected final EndpointConfig endpointConfig;
    protected final EndpointQualifier endpointQualifier;
    final Plane[] planes;
    final int planeCount;
    final ConnectionLifecycleListenerImpl connectionLifecycleListener = new ConnectionLifecycleListenerImpl();
    @Probe(name="activeCount", level=ProbeLevel.MANDATORY)
    final Set<TcpServerConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    @Probe(name="acceptedSocketCount", level=ProbeLevel.MANDATORY)
    final Set<Channel> acceptedChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    @Probe(name="connectionListenerCount")
    final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final ConstructorFunction<Address, TcpServerConnectionErrorHandler> errorHandlerConstructor;

    TcpServerConnectionManagerBase(TcpServer tcpServer, EndpointConfig endpointConfig) {
        this.server = tcpServer;
        this.errorHandlerConstructor = endpoint -> new TcpServerConnectionErrorHandler(tcpServer.getContext(), (Address)endpoint);
        this.serverContext = tcpServer.getContext();
        this.endpointConfig = endpointConfig;
        this.endpointQualifier = endpointConfig != null ? endpointConfig.getQualifier() : null;
        this.logger = this.serverContext.getLoggingService().getLogger(TcpServerConnectionManager.class);
        this.networkStats = this.endpointQualifier == null ? null : new NetworkStatsImpl();
        this.planeCount = this.serverContext.properties().getInteger(ClusterProperty.CHANNEL_COUNT);
        this.planes = new Plane[this.planeCount];
        for (int planeIndex = 0; planeIndex < this.planes.length; ++planeIndex) {
            this.planes[planeIndex] = new Plane(planeIndex);
        }
    }

    public EndpointQualifier getEndpointQualifier() {
        return this.endpointQualifier;
    }

    void refreshNetworkStats() {
        if (this.networkStats != null) {
            this.networkStats.refresh();
        }
    }

    private void fireConnectionRemovedEvent(final Connection connection, final Address endPoint) {
        if (this.server.isLive()) {
            this.serverContext.getEventService().executeEventCallback(new StripedRunnable(){

                @Override
                public void run() {
                    TcpServerConnectionManagerBase.this.connectionListeners.forEach(listener -> listener.connectionRemoved(connection));
                }

                @Override
                public int getKey() {
                    return endPoint.hashCode();
                }
            });
        }
    }

    protected boolean send(Packet packet, Address target, SendTask sendTask, int streamId) {
        block6: {
            int retries;
            ServerConnection connection = this.get(target, streamId);
            if (connection != null) {
                return connection.write(packet);
            }
            if (sendTask == null) {
                sendTask = new SendTask(packet, target, streamId);
            }
            if ((retries = sendTask.retries) < 5 && this.serverContext.isNodeActive()) {
                this.getOrConnect(target, true, streamId);
                try {
                    this.server.scheduleDeferred(sendTask, (long)(retries + 1) * 100L, TimeUnit.MILLISECONDS);
                    return true;
                }
                catch (RejectedExecutionException e) {
                    if (this.server.isLive()) {
                        throw e;
                    }
                    if (!this.logger.isFinestEnabled()) break block6;
                    this.logger.finest("Packet send task is rejected. Packet cannot be sent to " + target);
                }
            }
        }
        return false;
    }

    protected TcpServerConnectionErrorHandler getErrorHandler(Address endpoint, int planeIndex) {
        ConcurrentHashMap<Address, TcpServerConnectionErrorHandler> errorHandlers = this.planes[planeIndex].errorHandlers;
        return this.getErrorHandler(endpoint, errorHandlers);
    }

    private TcpServerConnectionErrorHandler getErrorHandler(Address endpoint, ConcurrentHashMap<Address, TcpServerConnectionErrorHandler> errorHandlers) {
        return ConcurrencyUtil.getOrPutIfAbsent(errorHandlers, endpoint, this.errorHandlerConstructor);
    }

    private class NetworkStatsImpl
    implements NetworkStats {
        private final AtomicLong bytesReceivedLastCalc = new AtomicLong();
        private final MwCounter bytesReceivedOnClosed = MwCounter.newMwCounter();
        private final AtomicLong bytesSentLastCalc = new AtomicLong();
        private final MwCounter bytesSentOnClosed = MwCounter.newMwCounter();

        private NetworkStatsImpl() {
        }

        @Override
        public long getBytesReceived() {
            return this.bytesReceivedLastCalc.get();
        }

        @Override
        public long getBytesSent() {
            return this.bytesSentLastCalc.get();
        }

        void refresh() {
            MutableLong totalReceived = MutableLong.valueOf(this.bytesReceivedOnClosed.get());
            MutableLong totalSent = MutableLong.valueOf(this.bytesSentOnClosed.get());
            TcpServerConnectionManagerBase.this.connections.forEach(conn -> {
                totalReceived.value += conn.getChannel().bytesRead();
                totalSent.value += conn.getChannel().bytesWritten();
            });
            this.bytesReceivedLastCalc.updateAndGet(v -> Math.max(v, totalReceived.value));
            this.bytesSentLastCalc.updateAndGet(v -> Math.max(v, totalSent.value));
        }

        void onConnectionClose(TcpServerConnection connection) {
            this.bytesReceivedOnClosed.inc(connection.getChannel().bytesRead());
            this.bytesSentOnClosed.inc(connection.getChannel().bytesWritten());
        }
    }

    private final class ConnectionLifecycleListenerImpl
    implements ConnectionLifecycleListener<TcpServerConnection> {
        private ConnectionLifecycleListenerImpl() {
        }

        @Override
        public void onConnectionClose(TcpServerConnection connection, Throwable cause, boolean silent) {
            boolean hadNoDataTraffic;
            Address remoteAddress;
            TcpServerConnectionManagerBase.this.closedCount.inc();
            TcpServerConnectionManagerBase.this.connections.remove(connection);
            if (TcpServerConnectionManagerBase.this.networkStats != null) {
                TcpServerConnectionManagerBase.this.networkStats.onConnectionClose(connection);
            }
            if ((remoteAddress = connection.getRemoteAddress()) == null) {
                return;
            }
            Plane plane = null;
            int planeIndex = connection.getPlaneIndex();
            if (planeIndex > -1) {
                plane = TcpServerConnectionManagerBase.this.planes[connection.getPlaneIndex()];
                plane.removeConnection(connection);
                TcpServerConnectionManagerBase.this.fireConnectionRemovedEvent(connection, remoteAddress);
            } else {
                boolean removed = false;
                for (Plane p : TcpServerConnectionManagerBase.this.planes) {
                    if (p.removeConnectionInProgress(remoteAddress)) {
                        plane = p;
                    }
                    if (!p.removeConnectionsWithId(connection.getConnectionId())) continue;
                    plane = p;
                    removed = true;
                }
                if (removed) {
                    TcpServerConnectionManagerBase.this.fireConnectionRemovedEvent(connection, remoteAddress);
                }
            }
            long lastReadTime = connection.getChannel().lastReadTimeMillis();
            boolean bl = hadNoDataTraffic = lastReadTime < 0L;
            if (hadNoDataTraffic) {
                TcpServerConnectionManagerBase.this.serverContext.onFailedConnection(remoteAddress);
                if (!silent && plane != null) {
                    TcpServerConnectionManagerBase.this.getErrorHandler(remoteAddress, plane.errorHandlers).onError(cause);
                }
            }
        }
    }

    private final class SendTask
    implements Runnable {
        private final Packet packet;
        private final Address target;
        private final int streamId;
        private volatile int retries;

        private SendTask(Packet packet, Address target, int streamId) {
            this.packet = packet;
            this.target = target;
            this.streamId = streamId;
        }

        @Override
        @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="single-writer, many-reader")
        public void run() {
            ++this.retries;
            if (TcpServerConnectionManagerBase.this.logger.isFinestEnabled()) {
                TcpServerConnectionManagerBase.this.logger.finest("Retrying[" + this.retries + "] packet send operation to: " + this.target);
            }
            TcpServerConnectionManagerBase.this.send(this.packet, this.target, this, this.streamId);
        }
    }

    static class Plane {
        final ConcurrentHashMap<Address, TcpServerConnectionErrorHandler> errorHandlers = new ConcurrentHashMap(100);
        final int index;
        private final ConcurrentHashMap<Address, TcpServerConnection> connectionMap = new ConcurrentHashMap(100);
        private final Set<Address> connectionsInProgress = Collections.newSetFromMap(new ConcurrentHashMap());

        Plane(int index) {
            this.index = index;
        }

        TcpServerConnection getConnection(Address address) {
            return this.connectionMap.get(address);
        }

        void putConnection(Address address, TcpServerConnection connection) {
            this.connectionMap.put(address, connection);
        }

        void putConnectionIfAbsent(Address address, TcpServerConnection connection) {
            this.connectionMap.putIfAbsent(address, connection);
        }

        void removeConnection(TcpServerConnection connection) {
            this.removeConnectionInProgress(connection.getRemoteAddress());
            Iterator<TcpServerConnection> connections = this.connectionMap.values().iterator();
            while (connections.hasNext()) {
                TcpServerConnection c = connections.next();
                if (!c.equals(connection)) continue;
                connections.remove();
            }
        }

        public boolean removeConnectionsWithId(int id) {
            boolean found = false;
            Iterator<TcpServerConnection> connections = this.connectionMap.values().iterator();
            while (connections.hasNext()) {
                TcpServerConnection c = connections.next();
                if (c.getConnectionId() != id) continue;
                connections.remove();
                found = true;
            }
            return found;
        }

        public void forEachConnection(Consumer<? super TcpServerConnection> consumer) {
            this.connectionMap.values().forEach(consumer);
        }

        public void clearConnections() {
            this.connectionMap.clear();
        }

        public Set<Map.Entry<Address, TcpServerConnection>> connections() {
            return Collections.unmodifiableSet(this.connectionMap.entrySet());
        }

        public int connectionCount() {
            return (int)this.connectionMap.values().stream().distinct().count();
        }

        public boolean hasConnectionInProgress(Address address) {
            return this.connectionsInProgress.contains(address);
        }

        public boolean addConnectionInProgress(Address address) {
            return this.connectionsInProgress.add(address);
        }

        public boolean removeConnectionInProgress(Address address) {
            return this.connectionsInProgress.remove(address);
        }

        public void clearConnectionsInProgress() {
            this.connectionsInProgress.clear();
        }

        public int connectionsInProgressCount() {
            return this.connectionsInProgress.size();
        }
    }
}

