/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.cluster.impl.MemberHandshake;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.SendMemberHandshakeTask;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.server.tcp.TcpServerConnectionManager;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public final class TcpServerControl {
    private final TcpServerConnectionManager connectionManager;
    private final ServerContext serverContext;
    private final ILogger logger;
    private final boolean spoofingChecks;
    private final boolean unifiedEndpointManager;
    private final Set<ProtocolType> supportedProtocolTypes;
    private final int expectedPlaneCount;

    public TcpServerControl(TcpServerConnectionManager connectionManager, ServerContext serverContext, ILogger logger, Set<ProtocolType> supportedProtocolTypes) {
        this.connectionManager = connectionManager;
        this.serverContext = serverContext;
        this.logger = logger;
        this.spoofingChecks = serverContext.properties().getBoolean(ClusterProperty.BIND_SPOOFING_CHECKS);
        this.supportedProtocolTypes = supportedProtocolTypes;
        this.unifiedEndpointManager = connectionManager.getEndpointQualifier() == null;
        this.expectedPlaneCount = serverContext.properties().getInteger(ClusterProperty.CHANNEL_COUNT);
    }

    public void process(Packet packet) {
        MemberHandshake handshake = (MemberHandshake)this.serverContext.getSerializationService().toObject(packet);
        TcpServerConnection connection = (TcpServerConnection)packet.getConn();
        if (!connection.setHandshake()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection " + connection + " handshake is already completed, ignoring incoming " + handshake);
            }
            return;
        }
        if (handshake.getPlaneCount() != this.expectedPlaneCount) {
            connection.close("The connection handshake has incorrect number of planes. Expected " + this.expectedPlaneCount + " found " + handshake.getPlaneCount(), null);
            return;
        }
        connection.setPlaneIndex(handshake.getPlaneIndex());
        this.process(connection, handshake);
    }

    private synchronized void process(TcpServerConnection connection, MemberHandshake handshake) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Handshake " + connection + ", complete message is " + handshake);
        }
        Map<ProtocolType, Collection<Address>> remoteAddressesPerProtocolType = handshake.getLocalAddresses();
        ArrayList<Address> allAliases = new ArrayList<Address>();
        for (Map.Entry<ProtocolType, Collection<Address>> remoteAddresses : remoteAddressesPerProtocolType.entrySet()) {
            if (!this.supportedProtocolTypes.contains((Object)remoteAddresses.getKey())) continue;
            allAliases.addAll(remoteAddresses.getValue());
        }
        assert (this.connectionManager.getEndpointQualifier() != EndpointQualifier.MEMBER || connection.getConnectionType().equals("MEMBER")) : "When handling MEMBER connections, connection type must be already set";
        boolean isMemberConnection = connection.getConnectionType().equals("MEMBER") && (this.connectionManager.getEndpointQualifier() == EndpointQualifier.MEMBER || this.unifiedEndpointManager);
        boolean mustRegisterRemoteSocketAddress = !handshake.isReply();
        Address remoteEndpoint = null;
        if (isMemberConnection) {
            if (mustRegisterRemoteSocketAddress) {
                allAliases.add(new Address(connection.getRemoteSocketAddress()));
            }
        } else {
            remoteEndpoint = new Address(connection.getRemoteSocketAddress());
        }
        this.process0(connection, remoteEndpoint, allAliases, handshake);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"})
    private synchronized void process0(TcpServerConnection connection, Address remoteEndpoint, Collection<Address> remoteAddressAliases, MemberHandshake handshake) {
        Address remoteAddress = new Address(connection.getRemoteSocketAddress());
        if (this.connectionManager.planes[handshake.getPlaneIndex()].hasConnectionInProgress(remoteAddress)) {
            remoteEndpoint = remoteAddress;
        }
        if (remoteEndpoint == null) {
            if (remoteAddressAliases == null) {
                throw new IllegalStateException("Remote endpoint and remote address aliases cannot be both null");
            }
            remoteEndpoint = remoteAddressAliases.iterator().next();
        }
        connection.setRemoteAddress(remoteEndpoint);
        this.serverContext.onSuccessfulConnection(remoteEndpoint);
        if (handshake.isReply()) {
            new SendMemberHandshakeTask(this.logger, this.serverContext, connection, remoteEndpoint, false, handshake.getPlaneIndex(), handshake.getPlaneCount()).run();
        }
        if (this.checkAlreadyConnected(connection, remoteEndpoint, handshake.getPlaneIndex())) {
            return;
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Registering connection " + connection + " to address " + remoteEndpoint + " planeIndex:" + handshake.getPlaneIndex());
        }
        boolean registered = this.connectionManager.register(remoteEndpoint, connection, handshake.getPlaneIndex());
        if (remoteAddressAliases != null && registered) {
            for (Address remoteAddressAlias : remoteAddressAliases) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Registering connection " + connection + " to address alias " + remoteAddressAlias + " planeIndex:" + handshake.getPlaneIndex());
                }
                this.connectionManager.planes[handshake.getPlaneIndex()].putConnectionIfAbsent(remoteAddressAlias, connection);
            }
        }
    }

    private boolean checkAlreadyConnected(TcpServerConnection connection, Address remoteEndPoint, int planeIndex) {
        TcpServerConnection existingConnection = this.connectionManager.planes[planeIndex].getConnection(remoteEndPoint);
        if (existingConnection != null && existingConnection.isAlive()) {
            if (existingConnection != connection) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest(existingConnection + " is already bound to " + remoteEndPoint + ", new one is " + connection + " planeIndex:" + planeIndex);
                }
                this.connectionManager.connections.add(connection);
            }
            return true;
        }
        return false;
    }
}

