/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.phonehome.BuildInfoCollector;
import com.hazelcast.internal.util.phonehome.CacheInfoCollector;
import com.hazelcast.internal.util.phonehome.ClientInfoCollector;
import com.hazelcast.internal.util.phonehome.CloudInfoCollector;
import com.hazelcast.internal.util.phonehome.ClusterInfoCollector;
import com.hazelcast.internal.util.phonehome.DistributedObjectCounterCollector;
import com.hazelcast.internal.util.phonehome.MapInfoCollector;
import com.hazelcast.internal.util.phonehome.MetricsCollector;
import com.hazelcast.internal.util.phonehome.OSInfoCollector;
import com.hazelcast.internal.util.phonehome.PhoneHomeParameterCreator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PhoneHome {
    private static final String FALSE = "false";
    private static final String DEFAULT_BASE_PHONE_HOME_URL = "https://phonehome.hazelcast.com/ping";
    private static final MetricsCollector CLOUD_INFO_COLLECTOR = new CloudInfoCollector();
    protected final Node hazelcastNode;
    volatile ScheduledFuture<?> phoneHomeFuture;
    private final ILogger logger;
    private final String basePhoneHomeUrl;
    private final List<MetricsCollector> metricsCollectorList;

    public PhoneHome(Node node) {
        this(node, DEFAULT_BASE_PHONE_HOME_URL, CLOUD_INFO_COLLECTOR);
    }

    PhoneHome(Node node, String baseUrl, MetricsCollector ... additionalCollectors) {
        this.hazelcastNode = node;
        this.logger = this.hazelcastNode.getLogger(PhoneHome.class);
        this.basePhoneHomeUrl = baseUrl;
        this.metricsCollectorList = new ArrayList<MetricsCollector>(additionalCollectors.length + 7);
        Collections.addAll(this.metricsCollectorList, new BuildInfoCollector(), new ClusterInfoCollector(), new ClientInfoCollector(), new MapInfoCollector(), new OSInfoCollector(), new DistributedObjectCounterCollector(), new CacheInfoCollector());
        Collections.addAll(this.metricsCollectorList, additionalCollectors);
    }

    public void check() {
        if (!PhoneHome.isPhoneHomeEnabled(this.hazelcastNode)) {
            return;
        }
        try {
            this.phoneHomeFuture = this.hazelcastNode.nodeEngine.getExecutionService().scheduleWithRepetition("PhoneHome", () -> this.phoneHome(false), 0L, 1L, TimeUnit.DAYS);
        }
        catch (RejectedExecutionException e) {
            this.logger.warning("Could not schedule phone home task! Most probably Hazelcast failed to start.");
        }
    }

    public void shutdown() {
        if (this.phoneHomeFuture != null) {
            this.phoneHomeFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPhoneHomeData(String requestBody) {
        HttpURLConnection conn = null;
        OutputStreamWriter writer = null;
        try {
            URL url = new URL(this.basePhoneHomeUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.connect();
            writer = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);
            writer.write(requestBody);
            writer.flush();
            conn.getContent();
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    EmptyStatement.ignore(e);
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public Map<String, String> phoneHome(boolean pretend) {
        PhoneHomeParameterCreator parameterCreator = this.createParameters();
        if (!pretend) {
            this.postPhoneHomeData(parameterCreator.build());
        }
        return parameterCreator.getParameters();
    }

    public PhoneHomeParameterCreator createParameters() {
        PhoneHomeParameterCreator parameterCreator = new PhoneHomeParameterCreator();
        for (MetricsCollector metricsCollector : this.metricsCollectorList) {
            try {
                metricsCollector.forEachMetric(this.hazelcastNode, (type, value) -> parameterCreator.addParam(type.getRequestParameterName(), (String)value));
            }
            catch (Exception e) {
                this.logger.warning("Some metrics were not recorded ", e);
            }
        }
        return parameterCreator;
    }

    public static boolean isPhoneHomeEnabled(Node node) {
        if (!node.getProperties().getBoolean(ClusterProperty.PHONE_HOME_ENABLED)) {
            return false;
        }
        return !FALSE.equals(System.getenv("HZ_PHONE_HOME_ENABLED"));
    }
}

