/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.yaml;

import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNameNodePair;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.internal.yaml.YamlScalar;
import com.hazelcast.internal.yaml.YamlSequence;
import com.hazelcast.org.json.JSONArray;
import com.hazelcast.org.json.JSONObject;

public final class YamlToJsonConverter {
    private YamlToJsonConverter() {
    }

    public static Object convert(YamlNode yamlNode) {
        if (yamlNode == null) {
            return JSONObject.NULL;
        }
        if (yamlNode instanceof YamlMapping) {
            YamlMapping yamlMapping = (YamlMapping)yamlNode;
            JSONObject resultObject = new JSONObject();
            for (YamlNameNodePair pair : yamlMapping.childrenPairs()) {
                resultObject.put(pair.nodeName(), YamlToJsonConverter.convert(pair.childNode()));
            }
            return resultObject;
        }
        if (yamlNode instanceof YamlSequence) {
            YamlSequence yamlSequence = (YamlSequence)yamlNode;
            JSONArray resultArray = new JSONArray();
            for (YamlNode child : yamlSequence.children()) {
                resultArray.put(YamlToJsonConverter.convert(child));
            }
            return resultArray;
        }
        if (yamlNode instanceof YamlScalar) {
            return YamlToJsonConverter.convertScalar((YamlScalar)yamlNode);
        }
        throw new IllegalArgumentException("Unknown type " + yamlNode.getClass().getName());
    }

    private static Object convertScalar(YamlScalar yamlNode) {
        Object rawNodeValue = yamlNode.nodeValue();
        if (rawNodeValue instanceof String) {
            String stringValue = (String)rawNodeValue;
            if (stringValue.equals("true")) {
                return Boolean.TRUE;
            }
            if (stringValue.equals("false")) {
                return Boolean.FALSE;
            }
            try {
                return new Integer(stringValue);
            }
            catch (NumberFormatException e) {
                try {
                    return new Float(stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return rawNodeValue;
    }
}

