/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.config;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.config.InstanceConfig;
import javax.annotation.Nonnull;

public class JetConfig {
    private InstanceConfig instanceConfig = new InstanceConfig();
    private EdgeConfig defaultEdgeConfig = new EdgeConfig();
    private boolean enabled;
    private boolean resourceUploadEnabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    public JetConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isResourceUploadEnabled() {
        return this.resourceUploadEnabled;
    }

    public JetConfig setResourceUploadEnabled(boolean resourceUploadEnabled) {
        this.resourceUploadEnabled = resourceUploadEnabled;
        return this;
    }

    @Nonnull
    public InstanceConfig getInstanceConfig() {
        return this.instanceConfig;
    }

    @Nonnull
    public JetConfig setInstanceConfig(@Nonnull InstanceConfig instanceConfig) {
        Preconditions.checkNotNull(instanceConfig, "instanceConfig");
        this.instanceConfig = instanceConfig;
        return this;
    }

    @Nonnull
    public EdgeConfig getDefaultEdgeConfig() {
        return this.defaultEdgeConfig;
    }

    @Nonnull
    public JetConfig setDefaultEdgeConfig(@Nonnull EdgeConfig defaultEdgeConfig) {
        Preconditions.checkNotNull(defaultEdgeConfig, "defaultEdgeConfig");
        this.defaultEdgeConfig = defaultEdgeConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JetConfig jetConfig = (JetConfig)o;
        if (this.enabled != jetConfig.enabled) {
            return false;
        }
        if (this.resourceUploadEnabled != jetConfig.resourceUploadEnabled) {
            return false;
        }
        if (!this.instanceConfig.equals(jetConfig.instanceConfig)) {
            return false;
        }
        return this.defaultEdgeConfig.equals(jetConfig.defaultEdgeConfig);
    }

    public int hashCode() {
        int result = this.instanceConfig.hashCode();
        result = 31 * result + this.defaultEdgeConfig.hashCode();
        result = 31 * result + (this.enabled ? 1 : 0);
        result = 31 * result + (this.resourceUploadEnabled ? 1 : 0);
        return result;
    }
}

