/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.metrics.impl.MetricsService;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.MembershipAwareService;
import com.hazelcast.internal.services.MembershipServiceEvent;
import com.hazelcast.jet.JetService;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JetProperties;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.impl.JetInstanceImpl;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobRecord;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.JobResult;
import com.hazelcast.jet.impl.LiveOperationRegistry;
import com.hazelcast.jet.impl.Networking;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.metrics.JobMetricsPublisher;
import com.hazelcast.jet.impl.operation.NotifyMemberShutdownOperation;
import com.hazelcast.jet.impl.serialization.DelegatingSerializationService;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.sql.impl.JetSqlCoreBackend;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class JetServiceBackend
implements ManagedService,
MembershipAwareService,
LiveOperationsTracker {
    public static final String SERVICE_NAME = "hz:impl:jetService";
    public static final int MAX_PARALLEL_ASYNC_OPS = 1000;
    private static final int NOTIFY_MEMBER_SHUTDOWN_DELAY = 5;
    private static final int SHUTDOWN_JOBS_MAX_WAIT_SECONDS = 10;
    private NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final LiveOperationRegistry liveOperationRegistry;
    private final AtomicReference<CompletableFuture<Void>> shutdownFuture = new AtomicReference();
    private final JetConfig jetConfig;
    private HazelcastInstance hazelcastInstance;
    private JetService jet;
    private Networking networking;
    private TaskletExecutionService taskletExecutionService;
    private JobRepository jobRepository;
    private JobCoordinationService jobCoordinationService;
    private JobExecutionService jobExecutionService;
    private final AtomicInteger numConcurrentAsyncOps = new AtomicInteger();
    private final Supplier<int[]> sharedPartitionKeys = Util.memoizeConcurrent(this::computeSharedPartitionKeys);
    @Nullable
    private final JetSqlCoreBackend sqlCoreBackend;

    public JetServiceBackend(Node node) {
        JetSqlCoreBackend sqlCoreBackend;
        this.logger = node.getLogger(this.getClass());
        this.liveOperationRegistry = new LiveOperationRegistry();
        this.jetConfig = node.getConfig().getJetConfig();
        try {
            Class<?> jetSqlServiceClass = Class.forName("com.hazelcast.jet.sql.impl.JetSqlCoreBackendImpl");
            sqlCoreBackend = (JetSqlCoreBackend)jetSqlServiceClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            sqlCoreBackend = null;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.sqlCoreBackend = sqlCoreBackend;
    }

    @Override
    public void init(NodeEngine engine, Properties hzProperties) {
        this.nodeEngine = (NodeEngineImpl)engine;
        this.hazelcastInstance = engine.getHazelcastInstance();
        this.jet = new JetInstanceImpl(this.nodeEngine.getNode().hazelcastInstance, this.jetConfig);
        this.taskletExecutionService = new TaskletExecutionService(this.nodeEngine, this.jetConfig.getInstanceConfig().getCooperativeThreadCount(), this.nodeEngine.getProperties());
        this.jobRepository = new JobRepository(this.hazelcastInstance);
        this.jobExecutionService = new JobExecutionService(this.nodeEngine, this.taskletExecutionService, this.jobRepository);
        this.jobCoordinationService = this.createJobCoordinationService();
        MetricsService metricsService = (MetricsService)this.nodeEngine.getService("hz:impl:metricsService");
        metricsService.registerPublisher(nodeEngine -> new JobMetricsPublisher(this.jobExecutionService, nodeEngine.getLocalMember()));
        this.nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this.jobExecutionService);
        this.networking = new Networking(engine, this.jobExecutionService, this.jetConfig.getInstanceConfig().getFlowControlPeriodMs());
        ClientEngine clientEngine = (ClientEngine)engine.getService("hz:core:clientEngine");
        ClientExceptionFactory clientExceptionFactory = clientEngine.getExceptionFactory();
        if (clientExceptionFactory != null) {
            ExceptionUtil.registerJetExceptions(clientExceptionFactory);
        } else {
            this.logger.fine("Jet exceptions are not registered to the ClientExceptionFactory since the ClientExceptionFactory is not accessible.");
        }
        this.logger.info("Setting number of cooperative threads and default parallelism to " + this.jetConfig.getInstanceConfig().getCooperativeThreadCount());
        if (this.sqlCoreBackend != null) {
            try {
                Method initJetInstanceMethod = this.sqlCoreBackend.getClass().getMethod("init", HazelcastInstance.class);
                initJetInstanceMethod.invoke((Object)this.sqlCoreBackend, this.hazelcastInstance);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void configureJetInternalObjects(Config config, HazelcastProperties properties) {
        JetConfig jetConfig = config.getJetConfig();
        MapConfig internalMapConfig = new MapConfig("__jet.*").setBackupCount(jetConfig.getInstanceConfig().getBackupCount()).setStatisticsEnabled(true);
        internalMapConfig.getMergePolicyConfig().setPolicy(DiscardMergePolicy.class.getName());
        MapConfig resultsMapConfig = new MapConfig(internalMapConfig).setName("__jet.results").setTimeToLiveSeconds(properties.getSeconds(JetProperties.JOB_RESULTS_TTL_SECONDS));
        MapConfig metricsMapConfig = new MapConfig(internalMapConfig).setName("__jet.results.metrics").setTimeToLiveSeconds(properties.getSeconds(JetProperties.JOB_RESULTS_TTL_SECONDS));
        config.addMapConfig(internalMapConfig).addMapConfig(resultsMapConfig).addMapConfig(metricsMapConfig);
    }

    public void shutDownJobs() {
        if (this.shutdownFuture.compareAndSet(null, new CompletableFuture())) {
            this.notifyMasterWeAreShuttingDown(this.shutdownFuture.get());
        }
        try {
            CompletableFuture<Void> future = this.shutdownFuture.get();
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.severe("Shutdown jobs timeout", e);
        }
    }

    private void notifyMasterWeAreShuttingDown(CompletableFuture<Void> future) {
        NotifyMemberShutdownOperation op = new NotifyMemberShutdownOperation();
        this.nodeEngine.getOperationService().invokeOnTarget(SERVICE_NAME, op, this.nodeEngine.getClusterService().getMasterAddress()).whenCompleteAsync((response, throwable) -> {
            if (throwable != null) {
                this.logger.warning("Failed to notify master member that this member is shutting down, will retry in 5 seconds", (Throwable)throwable);
                this.nodeEngine.getExecutionService().schedule(() -> this.notifyMasterWeAreShuttingDown(future), 5L, TimeUnit.SECONDS);
            } else {
                future.complete(null);
            }
        });
    }

    @Override
    public void shutdown(boolean forceful) {
        this.jobExecutionService.shutdown();
        this.taskletExecutionService.shutdown();
        this.taskletExecutionService.awaitWorkerTermination();
        this.networking.shutdown();
    }

    @Override
    public void reset() {
        this.jobExecutionService.reset();
        this.jobCoordinationService.reset();
    }

    JobCoordinationService createJobCoordinationService() {
        return new JobCoordinationService(this.nodeEngine, this, this.jetConfig, this.jobRepository);
    }

    public InternalSerializationService createSerializationService(Map<String, String> serializerConfigs) {
        return DelegatingSerializationService.from(this.getNodeEngine().getSerializationService(), serializerConfigs);
    }

    public Operation createExportSnapshotOperation(long jobId, String name, boolean cancelJob) {
        throw new UnsupportedOperationException("You need Hazelcast Jet Enterprise to use this feature");
    }

    public JetService getJet() {
        return this.jet;
    }

    public LiveOperationRegistry getLiveOperationRegistry() {
        return this.liveOperationRegistry;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    public JetConfig getJetConfig() {
        return this.jetConfig;
    }

    public JobCoordinationService getJobCoordinationService() {
        return this.jobCoordinationService;
    }

    public JobExecutionService getJobExecutionService() {
        return this.jobExecutionService;
    }

    public JobConfig getJobConfig(long jobId) {
        JobRecord jobRecord = this.jobRepository.getJobRecord(jobId);
        if (jobRecord != null) {
            return jobRecord.getConfig();
        }
        JobResult jobResult = this.jobRepository.getJobResult(jobId);
        if (jobResult != null) {
            return jobResult.getJobConfig();
        }
        throw new JobNotFoundException(jobId);
    }

    public ClassLoader getClassLoader(long jobId) {
        return this.getJobExecutionService().getClassLoader(this.getJobConfig(jobId), jobId);
    }

    public void handlePacket(Packet packet) {
        try {
            this.networking.handle(packet);
        }
        catch (IOException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        this.jobExecutionService.onMemberRemoved(event.getMember().getAddress());
        this.jobCoordinationService.onMemberRemoved(event.getMember().getUuid());
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
        this.jobCoordinationService.onMemberAdded(event.getMember());
    }

    public AtomicInteger numConcurrentAsyncOps() {
        return this.numConcurrentAsyncOps;
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        this.liveOperationRegistry.populate(liveOperations);
    }

    public int[] getSharedPartitionKeys() {
        return this.sharedPartitionKeys.get();
    }

    private int[] computeSharedPartitionKeys() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int[] keys = new int[partitionService.getPartitionCount()];
        int remainingCount = partitionService.getPartitionCount();
        int i = 1;
        while (remainingCount > 0) {
            int partitionId = partitionService.getPartitionId(i);
            if (keys[partitionId] == 0) {
                keys[partitionId] = i;
                --remainingCount;
            }
            ++i;
        }
        return keys;
    }

    @Nullable
    public JetSqlCoreBackend getSqlCoreBackend() {
        return this.sqlCoreBackend;
    }

    public TaskletExecutionService getTaskletExecutionService() {
        return this.taskletExecutionService;
    }
}

