/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class JetSubmitJobCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16646400;
    public static final int RESPONSE_MESSAGE_TYPE = 16646401;
    private static final int REQUEST_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_IS_LIGHT_JOB_FIELD_OFFSET = 24;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 25;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetSubmitJobCodec() {
    }

    public static ClientMessage encodeRequest(long jobId, Data dag, @Nullable Data jobConfig, boolean isLightJob) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Jet.SubmitJob");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[25], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16646400);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, jobId);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 24, isLightJob);
        clientMessage.add(initialFrame);
        DataCodec.encode(clientMessage, dag);
        CodecUtil.encodeNullable(clientMessage, jobConfig, DataCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.jobId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        if (initialFrame.content.length >= 25) {
            request.isLightJob = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 24);
            request.isIsLightJobExists = true;
        } else {
            request.isIsLightJobExists = false;
        }
        request.dag = DataCodec.decode(iterator);
        request.jobConfig = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16646401);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long jobId;
        public Data dag;
        @Nullable
        public Data jobConfig;
        public boolean isLightJob;
        public boolean isIsLightJobExists;
    }
}

