/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class JetTerminateJobCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16646656;
    public static final int RESPONSE_MESSAGE_TYPE = 16646657;
    private static final int REQUEST_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_TERMINATE_MODE_FIELD_OFFSET = 24;
    private static final int REQUEST_LIGHT_JOB_COORDINATOR_FIELD_OFFSET = 28;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 45;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetTerminateJobCodec() {
    }

    public static ClientMessage encodeRequest(long jobId, int terminateMode, @Nullable UUID lightJobCoordinator) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Jet.TerminateJob");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[45], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16646656);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, jobId);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, terminateMode);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 28, lightJobCoordinator);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.jobId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.terminateMode = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        if (initialFrame.content.length >= 45) {
            request.lightJobCoordinator = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 28);
            request.isLightJobCoordinatorExists = true;
        } else {
            request.isLightJobCoordinatorExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16646657);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long jobId;
        public int terminateMode;
        @Nullable
        public UUID lightJobCoordinator;
        public boolean isLightJobCoordinatorExists;
    }
}

