/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.client.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.jet.impl.client.protocol.codec.JetGetJobSummaryListCodec;
import com.hazelcast.jet.impl.operation.GetJobSummaryListOperation;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class JetGetJobSummaryListMessageTask
extends AbstractMultiTargetMessageTask<Void> {
    JetGetJobSummaryListMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Supplier<Operation> createOperationSupplier() {
        return GetJobSummaryListOperation::new;
    }

    @Override
    public Collection<Member> getTargets() {
        if (!this.nodeEngine.getConfig().getJetConfig().isEnabled()) {
            throw new IllegalArgumentException("Jet is disabled, see JetConfig#setEnabled.");
        }
        return this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
    }

    @Override
    protected Object reduce(Map<Member, Object> map) throws Throwable {
        return map.values().stream().flatMap(item -> ((List)item).stream()).filter(Util.distinctBy(JobSummary::getJobId)).collect(Collectors.toList());
    }

    @Override
    protected Void decodeClientMessage(ClientMessage clientMessage) {
        return null;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return JetGetJobSummaryListCodec.encodeResponse(this.serializationService.toData(response));
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getJobSummaryList";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public String getServiceName() {
        return "hz:impl:jetService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new JobPermission(new String[]{"read"});
    }
}

