/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.cache.ICache;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.cluster.Address;
import com.hazelcast.collection.IList;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.BinaryOperatorEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.connector.WriteBufferedP;
import com.hazelcast.jet.impl.connector.WriteMapP;
import com.hazelcast.jet.impl.connector.WriteObservableP;
import com.hazelcast.jet.impl.observer.ObservableImpl;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.security.impl.function.SecuredFunctions;
import com.hazelcast.security.permission.RingBufferPermission;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HazelcastWriters {
    private HazelcastWriters() {
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier writeMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.preferLocalParallelismOne(PermissionsUtil.mapPutPermission(clientXml, name), new WriteMapP.Supplier<T, K, V>(clientXml, name, toKeyFn, toValueFn));
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier mergeMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull BinaryOperatorEx<V> mergeFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toValueFn, "toValueFn");
        Util.checkSerializable(mergeFn, "mergeFn");
        return HazelcastWriters.updateMapSupplier(name, clientConfig, toKeyFn, (? super V oldValue, ? super T item) -> {
            Object newValue = toValueFn.apply(item);
            if (oldValue == null) {
                return newValue;
            }
            return mergeFn.apply((Object)oldValue, (Object)newValue);
        });
    }

    @Nonnull
    public static <T, K, V> ProcessorMetaSupplier updateMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(updateFn, "updateFn");
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.of(PermissionsUtil.mapUpdatePermission(clientXml, name), AbstractHazelcastConnectorSupplier.ofMap(clientXml, SecuredFunctions.updateMapProcessorFn(name, clientXml, toKeyFn, updateFn)));
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toEntryProcessorFn, "toEntryProcessorFn");
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.of(PermissionsUtil.mapUpdatePermission(clientXml, name), AbstractHazelcastConnectorSupplier.ofMap(clientXml, SecuredFunctions.updateWithEntryProcessorFn(1000, name, clientXml, toKeyFn, toEntryProcessorFn)));
    }

    @Nonnull
    public static <T, K, V, R> ProcessorMetaSupplier updateMapSupplier(int maxParallelAsyncOps, @Nonnull String name, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        Util.checkSerializable(toKeyFn, "toKeyFn");
        Util.checkSerializable(toEntryProcessorFn, "toEntryProcessorFn");
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.of(PermissionsUtil.mapUpdatePermission(clientXml, name), AbstractHazelcastConnectorSupplier.ofMap(clientXml, SecuredFunctions.updateWithEntryProcessorFn(maxParallelAsyncOps, name, clientXml, toKeyFn, toEntryProcessorFn)));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeCacheSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.preferLocalParallelismOne(PermissionsUtil.cachePutPermission(clientXml, name), new WriteCachePSupplier(clientXml, name));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeListSupplier(@Nonnull String name, @Nullable ClientConfig clientConfig) {
        String clientXml = ImdgUtil.asXmlString(clientConfig);
        return ProcessorMetaSupplier.preferLocalParallelismOne(PermissionsUtil.listAddPermission(clientXml, name), new WriteListPSupplier(clientXml, name));
    }

    public static ProcessorMetaSupplier writeObservableSupplier(final @Nonnull String name) {
        return new ProcessorMetaSupplier(){

            @Override
            @Nonnull
            public Map<String, String> getTags() {
                return Collections.singletonMap(ObservableImpl.OWNED_OBSERVABLE, name);
            }

            @Override
            public int preferredLocalParallelism() {
                return 1;
            }

            @Override
            @Nonnull
            public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return address -> new WriteObservableP.Supplier(name);
            }

            @Override
            public Permission getRequiredPermission() {
                return new RingBufferPermission(name, "create", "put");
            }
        };
    }

    static RuntimeException handleInstanceNotActive(HazelcastInstanceNotActiveException e, boolean isLocal) {
        return isLocal ? new RestartableException(e) : e;
    }

    static final class ArrayMap<K, V>
    extends AbstractMap<K, V> {
        private final List<Map.Entry<K, V>> entries;
        private final ArraySet set = new ArraySet();

        ArrayMap() {
            this.entries = new ArrayList<Map.Entry<K, V>>();
        }

        ArrayMap(int size) {
            this.entries = new ArrayList<Map.Entry<K, V>>(size);
        }

        @Override
        @Nonnull
        public Set<Map.Entry<K, V>> entrySet() {
            return this.set;
        }

        public void add(Map.Entry<K, V> entry) {
            this.entries.add(entry);
        }

        @Override
        public V get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            return this.entries.toString();
        }

        private class ArraySet
        extends AbstractSet<Map.Entry<K, V>> {
            private ArraySet() {
            }

            @Override
            @Nonnull
            public Iterator<Map.Entry<K, V>> iterator() {
                return ArrayMap.this.entries.iterator();
            }

            @Override
            public int size() {
                return ArrayMap.this.entries.size();
            }

            @Override
            public void clear() {
                ArrayMap.this.entries.clear();
            }
        }
    }

    private static class WriteListPSupplier<T>
    extends AbstractHazelcastConnectorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;

        WriteListPSupplier(@Nullable String clientXml, @Nonnull String name) {
            super(clientXml);
            this.name = name;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            IList list = instance.getList(this.name);
            FunctionEx<ProcessorSupplier.Context, List> bufferCreator = context -> new ArrayList();
            BiConsumerEx<List, Object> itemReceiver = (buffer, item) -> buffer.add(serializationService.toData(item));
            ConsumerEx<List> bufferFlusher = buffer -> {
                try {
                    list.addAll(buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
                }
                buffer.clear();
            };
            return new WriteBufferedP<List, Object>(bufferCreator, itemReceiver, bufferFlusher, ConsumerEx.noop());
        }

        @Override
        public Permission permission() {
            return PermissionsUtil.listAddPermission(this.clientXml, this.name);
        }
    }

    private static class WriteCachePSupplier<K, V>
    extends AbstractHazelcastConnectorSupplier {
        static final long serialVersionUID = 1L;
        private final String name;

        WriteCachePSupplier(@Nullable String clientXml, @Nonnull String name) {
            super(clientXml);
            this.name = name;
        }

        @Override
        protected Processor createProcessor(HazelcastInstance instance, SerializationService serializationService) {
            ICache cache = instance.getCacheManager().getCache(this.name);
            FunctionEx<ProcessorSupplier.Context, ArrayMap> bufferCreator = context -> new ArrayMap();
            BiConsumerEx<ArrayMap, Map.Entry> entryReceiver = (buffer, entry) -> {
                Object key = serializationService.toData(entry.getKey());
                Object value = serializationService.toData(entry.getValue());
                buffer.add(new AbstractMap.SimpleEntry(key, value));
            };
            ConsumerEx<ArrayMap> bufferFlusher = buffer -> {
                try {
                    cache.putAll((Map)buffer);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    throw HazelcastWriters.handleInstanceNotActive(e, this.isLocal());
                }
                buffer.clear();
            };
            return new WriteBufferedP<ArrayMap, Map.Entry>(bufferCreator, entryReceiver, bufferFlusher, ConsumerEx.noop());
        }

        @Override
        public Permission permission() {
            return PermissionsUtil.cachePutPermission(this.clientXml, this.name);
        }
    }
}

