/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public abstract class AbstractJobOperation
extends Operation
implements IdentifiedDataSerializable {
    private long jobId;

    protected AbstractJobOperation() {
    }

    protected AbstractJobOperation(long jobId) {
        this.jobId = jobId;
    }

    protected final long jobId() {
        return this.jobId;
    }

    @Override
    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.jobId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.jobId = in.readLong();
    }

    protected JetServiceBackend getJetServiceBackend() {
        if (!this.getNodeEngine().getConfig().getJetConfig().isEnabled()) {
            throw new IllegalArgumentException("Jet is disabled, see JetConfig#setEnabled.");
        }
        assert (this.getServiceName().equals("hz:impl:jetService")) : "Service is not Jet Service";
        return (JetServiceBackend)this.getService();
    }
}

