/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public abstract class AsyncOperation
extends Operation
implements IdentifiedDataSerializable {
    @Override
    public void beforeRun() {
        JetServiceBackend service = this.getJetServiceBackend();
        service.getLiveOperationRegistry().register(this);
    }

    @Override
    public final void run() {
        CompletableFuture<?> future;
        try {
            future = this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
            return;
        }
        future.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (r, f) -> this.doSendResponse(f != null ? ExceptionUtil.peel(f) : r)));
    }

    protected abstract CompletableFuture<?> doRun() throws Exception;

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendResponse(Object value) {
        try {
            JetServiceBackend service = this.getJetServiceBackend();
            service.getLiveOperationRegistry().deregister(this);
        }
        finally {
            try {
                this.sendResponse(value);
            }
            catch (Exception e) {
                Throwable ex = ExceptionUtil.peel(e);
                if (value instanceof Throwable && ex instanceof HazelcastSerializationException) {
                    this.sendResponse(new JetException(ExceptionUtil.stackTraceToString(ex)));
                }
                throw e;
            }
        }
    }

    protected JetServiceBackend getJetServiceBackend() {
        if (!this.getNodeEngine().getConfig().getJetConfig().isEnabled()) {
            throw new IllegalArgumentException("Jet is disabled, see JetConfig#setEnabled.");
        }
        assert (this.getServiceName().equals("hz:impl:jetService")) : "Service is not Jet Service";
        return (JetServiceBackend)this.getService();
    }

    protected JobCoordinationService getJobCoordinationService() {
        return this.getJetServiceBackend().getJobCoordinationService();
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return ExceptionUtil.isRestartableException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }
}

