/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.util.WrappingProcessorSupplier;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class WrappingProcessorMetaSupplier
implements ProcessorMetaSupplier {
    private ProcessorMetaSupplier wrapped;
    private FunctionEx<Processor, Processor> wrapperSupplier;

    public WrappingProcessorMetaSupplier(ProcessorMetaSupplier wrapped, FunctionEx<Processor, Processor> wrapperSupplier) {
        this.wrapped = wrapped;
        this.wrapperSupplier = wrapperSupplier;
    }

    @Override
    public int preferredLocalParallelism() {
        return this.wrapped.preferredLocalParallelism();
    }

    @Nonnull
    public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        Function<? super Address, ? extends ProcessorSupplier> function = this.wrapped.get(addresses);
        return address -> new WrappingProcessorSupplier((ProcessorSupplier)function.apply((Address)address), this.wrapperSupplier);
    }

    @Override
    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        this.wrapped.init(context);
    }

    @Override
    @Nonnull
    public Map<String, String> getTags() {
        return this.wrapped.getTags();
    }

    @Override
    public void close(Throwable error) throws Exception {
        this.wrapped.close(error);
    }

    @Override
    public Permission getRequiredPermission() {
        return this.wrapped.getRequiredPermission();
    }
}

