/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import java.io.File;
import java.io.Serializable;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SerializableByConvention
public final class ServiceFactory<C, S>
implements Serializable,
Cloneable {
    public static final boolean COOPERATIVE_DEFAULT = true;
    private boolean isCooperative = true;
    @Nonnull
    private final FunctionEx<? super ProcessorSupplier.Context, ? extends C> createContextFn;
    @Nonnull
    private BiFunctionEx<? super Processor.Context, ? super C, ? extends S> createServiceFn = (ctx, svcContext) -> {
        throw new IllegalStateException("This ServiceFactory is missing a createServiceFn");
    };
    @Nonnull
    private ConsumerEx<? super S> destroyServiceFn = ConsumerEx.noop();
    @Nonnull
    private ConsumerEx<? super C> destroyContextFn = ConsumerEx.noop();
    @Nonnull
    private Map<String, File> attachedFiles = Collections.emptyMap();
    @Nullable
    private Permission permission;

    private ServiceFactory(@Nonnull FunctionEx<? super ProcessorSupplier.Context, ? extends C> createContextFn) {
        this.createContextFn = createContextFn;
    }

    @Nonnull
    public static <C> ServiceFactory<C, Void> withCreateContextFn(@Nonnull FunctionEx<? super ProcessorSupplier.Context, ? extends C> createContextFn) {
        SerializationUtil.checkSerializable(createContextFn, "createContextFn");
        return new ServiceFactory(createContextFn);
    }

    @Nonnull
    public ServiceFactory<C, S> withDestroyContextFn(@Nonnull ConsumerEx<? super C> destroyContextFn) {
        SerializationUtil.checkSerializable(destroyContextFn, "destroyContextFn");
        Object copy = this.clone();
        ((ServiceFactory)copy).destroyContextFn = destroyContextFn;
        return copy;
    }

    @Nonnull
    public <S_NEW> ServiceFactory<C, S_NEW> withCreateServiceFn(@Nonnull BiFunctionEx<? super Processor.Context, ? super C, ? extends S_NEW> createServiceFn) {
        SerializationUtil.checkSerializable(createServiceFn, "createServiceFn");
        Object copy = this.clone();
        ((ServiceFactory)copy).createServiceFn = createServiceFn;
        return copy;
    }

    @Nonnull
    public ServiceFactory<C, S> withDestroyServiceFn(@Nonnull ConsumerEx<? super S> destroyServiceFn) {
        SerializationUtil.checkSerializable(destroyServiceFn, "destroyServiceFn");
        Object copy = this.clone();
        ((ServiceFactory)copy).destroyServiceFn = destroyServiceFn;
        return copy;
    }

    @Nonnull
    public ServiceFactory<C, S> toNonCooperative() {
        Object copy = this.clone();
        ((ServiceFactory)copy).isCooperative = false;
        return copy;
    }

    @Nonnull
    public ServiceFactory<C, S> withAttachedFile(@Nonnull String id, @Nonnull File file) {
        if (!file.isFile() || !file.canRead()) {
            throw new IllegalArgumentException("Not an existing, readable file: " + file);
        }
        return this.attachFileOrDir(id, file);
    }

    @Nonnull
    public ServiceFactory<C, S> withAttachedDirectory(@Nonnull String id, @Nonnull File directory) {
        if (!directory.isDirectory() || !directory.canRead()) {
            throw new IllegalArgumentException("Not an existing, readable directory: " + directory);
        }
        return this.attachFileOrDir(id, directory);
    }

    @Nonnull
    private ServiceFactory<C, S> attachFileOrDir(String id, @Nonnull File file) {
        Object copy = this.clone();
        ((ServiceFactory)copy).attachedFiles.put(id, file);
        return copy;
    }

    @Nonnull
    public ServiceFactory<C, S> withoutAttachedFiles() {
        Object copy = this.clone();
        ((ServiceFactory)copy).attachedFiles = Collections.emptyMap();
        return copy;
    }

    @Nonnull
    public ServiceFactory<C, S> withPermission(@Nonnull Permission permission) {
        Object copy = this.clone();
        ((ServiceFactory)copy).permission = permission;
        return copy;
    }

    @Nonnull
    public FunctionEx<? super ProcessorSupplier.Context, ? extends C> createContextFn() {
        return this.createContextFn;
    }

    @Nonnull
    public BiFunctionEx<? super Processor.Context, ? super C, ? extends S> createServiceFn() {
        return this.createServiceFn;
    }

    @Nonnull
    public ConsumerEx<? super S> destroyServiceFn() {
        return this.destroyServiceFn;
    }

    @Nonnull
    public ConsumerEx<? super C> destroyContextFn() {
        return this.destroyContextFn;
    }

    public boolean isCooperative() {
        return this.isCooperative;
    }

    @Nonnull
    public Map<String, File> attachedFiles() {
        return Collections.unmodifiableMap(this.attachedFiles);
    }

    @Nullable
    public Permission permission() {
        return this.permission;
    }

    protected ServiceFactory<C, S> clone() {
        try {
            ServiceFactory copy = (ServiceFactory)super.clone();
            copy.attachedFiles = new HashMap<String, File>(this.attachedFiles);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new JetException(this.getClass() + " is not cloneable", e);
        }
    }
}

