/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.file;

import com.hazelcast.jet.pipeline.file.FileFormat;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CsvFileFormat<T>
implements FileFormat<T> {
    public static final String FORMAT_CSV = "csv";
    private final Class<T> clazz;
    private final List<String> fieldNames;

    CsvFileFormat(@Nonnull Class<T> clazz) {
        this.clazz = clazz;
        this.fieldNames = null;
    }

    CsvFileFormat(@Nullable List<String> fieldNames) {
        this.clazz = String[].class;
        this.fieldNames = fieldNames;
    }

    @Override
    @Nonnull
    public String format() {
        return FORMAT_CSV;
    }

    @Nonnull
    public Class<T> clazz() {
        return this.clazz;
    }

    @Nullable
    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvFileFormat that = (CsvFileFormat)o;
        return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.fieldNames, that.fieldNames);
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.fieldNames);
    }
}

