/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.jet.sql.impl.opt.FieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static PredicateEx<Object[]> filterFn(@Nonnull Expression<Boolean> predicate, @Nonnull ExpressionEvalContext context) {
        return values -> {
            HeapRow row = new HeapRow((Object[])values);
            return Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context));
        };
    }

    public static ComparatorEx<Object[]> comparisonFn(@Nonnull List<FieldCollation> fieldCollationList) {
        return (row1, row2) -> {
            for (FieldCollation fieldCollation : fieldCollationList) {
                int index = fieldCollation.getIndex();
                Comparable o1 = (Comparable)row1[index];
                Object o2 = row2[index];
                RelFieldCollation.Direction direction = fieldCollation.getDirection();
                int result = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : o1.compareTo(o2)));
                if (direction.isDescending()) {
                    if (result < 0) {
                        result = 1;
                    } else if (result > 0) {
                        result = -1;
                    }
                }
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    public static FunctionEx<Object[], Object[]> projectionFn(@Nonnull List<Expression<?>> projections, @Nonnull ExpressionEvalContext context) {
        return values -> {
            HeapRow row = new HeapRow((Object[])values);
            Object[] result = new Object[projections.size()];
            for (int i = 0; i < projections.size(); ++i) {
                result[i] = ExpressionUtil.evaluate((Expression)projections.get(i), row, context);
            }
            return result;
        };
    }

    @Nullable
    public static Object[] join(@Nonnull Object[] leftRow, @Nonnull Object[] rightRow, @Nonnull Expression<Boolean> predicate, @Nonnull ExpressionEvalContext context) {
        Object[] joined = Arrays.copyOf(leftRow, leftRow.length + rightRow.length);
        System.arraycopy(rightRow, 0, joined, leftRow.length, rightRow.length);
        HeapRow row = new HeapRow(joined);
        return Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context)) ? joined : null;
    }

    @Nonnull
    public static List<Object[]> evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull List<Object[]> rows, @Nonnull ExpressionEvalContext context) {
        ArrayList<Object[]> evaluatedRows = new ArrayList<Object[]>();
        for (Object[] values : rows) {
            Object[] transformed = ExpressionUtil.evaluate(predicate, projection, values, context);
            if (transformed == null) continue;
            evaluatedRows.add(transformed);
        }
        return evaluatedRows;
    }

    @Nullable
    public static Object[] evaluate(@Nullable Expression<Boolean> predicate, @Nullable List<Expression<?>> projection, @Nonnull Object[] values, @Nonnull ExpressionEvalContext context) {
        HeapRow row = new HeapRow(values);
        if (predicate != null && !Boolean.TRUE.equals(ExpressionUtil.evaluate(predicate, row, context))) {
            return null;
        }
        if (projection == null) {
            return values;
        }
        Object[] result = new Object[projection.size()];
        for (int i = 0; i < projection.size(); ++i) {
            result[i] = ExpressionUtil.evaluate(projection.get(i), row, context);
        }
        return result;
    }

    public static <T> T evaluate(@Nonnull Expression<T> expression, @Nonnull Row row, @Nonnull ExpressionEvalContext context) {
        return expression.eval(row, context);
    }
}

