/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetPlanExecutor;
import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.optimizer.PlanCheckContext;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.Set;

abstract class JetPlan
extends SqlPlan {
    protected JetPlan(PlanKey planKey) {
        super(planKey);
    }

    abstract SqlResult execute(QueryId var1, List<Object> var2, long var3);

    protected void checkPermissions(SqlSecurityContext context, DAG dag) {
        if (!context.isSecurityEnabled()) {
            return;
        }
        context.checkPermission(new JobPermission(new String[]{"submit"}));
        for (Vertex vertex : dag) {
            Permission permission = vertex.getMetaSupplier().getRequiredPermission();
            if (permission == null) continue;
            context.checkPermission(permission);
        }
    }

    private static void ensureNoArguments(String name, List<Object> arguments) {
        if (!arguments.isEmpty()) {
            throw QueryException.error(name + " does not support dynamic parameters");
        }
    }

    private static void ensureNoTimeout(String name, long timeout) {
        if (timeout > 0L) {
            throw QueryException.error(name + " does not support timeout");
        }
    }

    static class IMapDeletePlan
    extends JetPlan {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final String mapName;
        private final Expression<?> keyCondition;
        private final JetPlanExecutor planExecutor;
        private final List<Permission> permissions;

        IMapDeletePlan(PlanKey planKey, PlanObjectKey objectKey, QueryParameterMetadata parameterMetadata, String mapName, Expression<?> keyCondition, JetPlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = Collections.singleton(objectKey);
            this.parameterMetadata = parameterMetadata;
            this.mapName = mapName;
            this.keyCondition = keyCondition;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata parameterMetadata() {
            return this.parameterMetadata;
        }

        String mapName() {
            return this.mapName;
        }

        Expression<?> keyCondition() {
            return this.keyCondition;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission(new MapPermission(this.mapName, "create", "remove"));
            for (Permission permission : this.permissions) {
                context.checkPermission(permission);
            }
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, arguments, timeout);
        }
    }

    static class DmlPlan
    extends JetPlan {
        private final TableModify.Operation operation;
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final DAG dag;
        private final JetPlanExecutor planExecutor;
        private final List<Permission> permissions;

        DmlPlan(TableModify.Operation operation, PlanKey planKey, QueryParameterMetadata parameterMetadata, Set<PlanObjectKey> objectKeys, DAG dag, JetPlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.operation = operation;
            this.objectKeys = objectKeys;
            this.parameterMetadata = parameterMetadata;
            this.dag = dag;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        TableModify.Operation getOperation() {
            return this.operation;
        }

        QueryParameterMetadata getParameterMetadata() {
            return this.parameterMetadata;
        }

        DAG getDag() {
            return this.dag;
        }

        @Override
        public boolean isCacheable() {
            return !this.objectKeys.contains(PlanObjectKey.NON_CACHEABLE_OBJECT_KEY);
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            this.checkPermissions(context, this.dag);
            for (Permission permission : this.permissions) {
                context.checkPermission(permission);
            }
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, queryId, arguments, timeout);
        }
    }

    static class SelectPlan
    extends JetPlan {
        private final Set<PlanObjectKey> objectKeys;
        private final QueryParameterMetadata parameterMetadata;
        private final DAG dag;
        private final boolean isStreaming;
        private final SqlRowMetadata rowMetadata;
        private final JetPlanExecutor planExecutor;
        private final List<Permission> permissions;

        SelectPlan(PlanKey planKey, QueryParameterMetadata parameterMetadata, Set<PlanObjectKey> objectKeys, DAG dag, boolean isStreaming, SqlRowMetadata rowMetadata, JetPlanExecutor planExecutor, List<Permission> permissions) {
            super(planKey);
            this.objectKeys = objectKeys;
            this.parameterMetadata = parameterMetadata;
            this.dag = dag;
            this.isStreaming = isStreaming;
            this.rowMetadata = rowMetadata;
            this.planExecutor = planExecutor;
            this.permissions = permissions;
        }

        QueryParameterMetadata getParameterMetadata() {
            return this.parameterMetadata;
        }

        DAG getDag() {
            return this.dag;
        }

        boolean isStreaming() {
            return this.isStreaming;
        }

        SqlRowMetadata getRowMetadata() {
            return this.rowMetadata;
        }

        @Override
        public boolean isCacheable() {
            return !this.objectKeys.contains(PlanObjectKey.NON_CACHEABLE_OBJECT_KEY);
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return context.isValid(this.objectKeys);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            this.checkPermissions(context, this.dag);
            for (Permission permission : this.permissions) {
                context.checkPermission(permission);
            }
        }

        @Override
        public boolean producesRows() {
            return true;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            return this.planExecutor.execute(this, queryId, arguments, timeout);
        }
    }

    static class ShowStatementPlan
    extends JetPlan {
        private final SqlShowStatement.ShowStatementTarget showTarget;
        private final JetPlanExecutor planExecutor;

        ShowStatementPlan(PlanKey planKey, SqlShowStatement.ShowStatementTarget showTarget, JetPlanExecutor planExecutor) {
            super(planKey);
            this.showTarget = showTarget;
            this.planExecutor = planExecutor;
        }

        SqlShowStatement.ShowStatementTarget getShowTarget() {
            return this.showTarget;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return true;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            if (this.showTarget != SqlShowStatement.ShowStatementTarget.MAPPINGS) {
                context.checkPermission(new JobPermission(new String[]{"read"}));
            }
        }

        @Override
        public boolean producesRows() {
            return true;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoArguments("SHOW " + (Object)((Object)this.showTarget), arguments);
            JetPlan.ensureNoTimeout("SHOW " + (Object)((Object)this.showTarget), timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class DropSnapshotPlan
    extends JetPlan {
        private final String snapshotName;
        private final boolean ifExists;
        private final JetPlanExecutor planExecutor;

        DropSnapshotPlan(PlanKey planKey, String snapshotName, boolean ifExists, JetPlanExecutor planExecutor) {
            super(planKey);
            this.snapshotName = snapshotName;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        String getSnapshotName() {
            return this.snapshotName;
        }

        boolean isIfExists() {
            return this.ifExists;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return true;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission(new JobPermission(new String[]{"export-snapshot"}));
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoArguments("DROP SNAPSHOT", arguments);
            JetPlan.ensureNoTimeout("DROP SNAPSHOT", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class CreateSnapshotPlan
    extends JetPlan {
        private final String snapshotName;
        private final String jobName;
        private final JetPlanExecutor planExecutor;

        CreateSnapshotPlan(PlanKey planKey, String snapshotName, String jobName, JetPlanExecutor planExecutor) {
            super(planKey);
            this.snapshotName = snapshotName;
            this.jobName = jobName;
            this.planExecutor = planExecutor;
        }

        String getSnapshotName() {
            return this.snapshotName;
        }

        String getJobName() {
            return this.jobName;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return true;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission(new JobPermission(new String[]{"export-snapshot"}));
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoArguments("CREATE SNAPSHOT", arguments);
            JetPlan.ensureNoTimeout("CREATE SNAPSHOT", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class DropJobPlan
    extends JetPlan {
        private final String jobName;
        private final boolean ifExists;
        private final String withSnapshotName;
        private final JetPlanExecutor planExecutor;

        DropJobPlan(PlanKey planKey, String jobName, boolean ifExists, String withSnapshotName, JetPlanExecutor planExecutor) {
            super(planKey);
            this.jobName = jobName;
            this.ifExists = ifExists;
            this.withSnapshotName = withSnapshotName;
            this.planExecutor = planExecutor;
        }

        String getJobName() {
            return this.jobName;
        }

        boolean isIfExists() {
            return this.ifExists;
        }

        String getWithSnapshotName() {
            return this.withSnapshotName;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return true;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            if (this.withSnapshotName == null) {
                context.checkPermission(new JobPermission(new String[]{"cancel"}));
            } else {
                context.checkPermission(new JobPermission(new String[]{"cancel", "export-snapshot"}));
            }
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoArguments("DROP JOB", arguments);
            JetPlan.ensureNoTimeout("DROP JOB", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class AlterJobPlan
    extends JetPlan {
        private final String jobName;
        private final SqlAlterJob.AlterJobOperation operation;
        private final JetPlanExecutor planExecutor;

        AlterJobPlan(PlanKey planKey, String jobName, SqlAlterJob.AlterJobOperation operation, JetPlanExecutor planExecutor) {
            super(planKey);
            this.jobName = jobName;
            this.operation = operation;
            this.planExecutor = planExecutor;
        }

        String getJobName() {
            return this.jobName;
        }

        SqlAlterJob.AlterJobOperation getOperation() {
            return this.operation;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return true;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            context.checkPermission(new JobPermission(new String[]{"restart"}));
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoArguments("ALTER JOB", arguments);
            JetPlan.ensureNoTimeout("ALTER JOB", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class CreateJobPlan
    extends JetPlan {
        private final JobConfig jobConfig;
        private final boolean ifNotExists;
        private final DmlPlan dmlPlan;
        private final JetPlanExecutor planExecutor;

        CreateJobPlan(PlanKey planKey, JobConfig jobConfig, boolean ifNotExists, DmlPlan dmlPlan, JetPlanExecutor planExecutor) {
            super(planKey);
            assert (dmlPlan.operation == TableModify.Operation.INSERT) : DmlPlan.access$200(dmlPlan);
            this.jobConfig = jobConfig;
            this.ifNotExists = ifNotExists;
            this.dmlPlan = dmlPlan;
            this.planExecutor = planExecutor;
        }

        JobConfig getJobConfig() {
            return this.jobConfig;
        }

        boolean isIfNotExists() {
            return this.ifNotExists;
        }

        DmlPlan getExecutionPlan() {
            return this.dmlPlan;
        }

        QueryParameterMetadata getParameterMetadata() {
            return this.dmlPlan.getParameterMetadata();
        }

        @Override
        public boolean isCacheable() {
            return this.dmlPlan.isCacheable();
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return this.dmlPlan.isPlanValid(context);
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
            this.dmlPlan.checkPermissions(context);
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoTimeout("CREATE JOB", timeout);
            return this.planExecutor.execute(this, arguments);
        }
    }

    static class DropMappingPlan
    extends JetPlan {
        private final String name;
        private final boolean ifExists;
        private final JetPlanExecutor planExecutor;

        DropMappingPlan(PlanKey planKey, String name, boolean ifExists, JetPlanExecutor planExecutor) {
            super(planKey);
            this.name = name;
            this.ifExists = ifExists;
            this.planExecutor = planExecutor;
        }

        String name() {
            return this.name;
        }

        boolean ifExists() {
            return this.ifExists;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return true;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoArguments("DROP MAPPING", arguments);
            JetPlan.ensureNoTimeout("DROP MAPPING", timeout);
            return this.planExecutor.execute(this);
        }
    }

    static class CreateMappingPlan
    extends JetPlan {
        private final Mapping mapping;
        private final boolean replace;
        private final boolean ifNotExists;
        private final JetPlanExecutor planExecutor;

        CreateMappingPlan(PlanKey planKey, Mapping mapping, boolean replace, boolean ifNotExists, JetPlanExecutor planExecutor) {
            super(planKey);
            this.mapping = mapping;
            this.replace = replace;
            this.ifNotExists = ifNotExists;
            this.planExecutor = planExecutor;
        }

        Mapping mapping() {
            return this.mapping;
        }

        boolean replace() {
            return this.replace;
        }

        boolean ifNotExists() {
            return this.ifNotExists;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }

        @Override
        public boolean isPlanValid(PlanCheckContext context) {
            return true;
        }

        @Override
        public void checkPermissions(SqlSecurityContext context) {
        }

        @Override
        public boolean producesRows() {
            return false;
        }

        @Override
        public SqlResult execute(QueryId queryId, List<Object> arguments, long timeout) {
            JetPlan.ensureNoArguments("CREATE MAPPING", arguments);
            JetPlan.ensureNoTimeout("CREATE MAPPING", timeout);
            return this.planExecutor.execute(this);
        }
    }
}

