/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.internal.util.concurrent.OneToOneConcurrentArrayQueue;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.Row;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class JetQueryResultProducer
implements QueryResultProducer {
    static final int QUEUE_CAPACITY = 4096;
    private static final Exception NORMAL_COMPLETION = new NormalCompletionException();
    private final OneToOneConcurrentArrayQueue<Row> rows = new OneToOneConcurrentArrayQueue(4096);
    private final AtomicReference<Exception> done = new AtomicReference();
    private InternalIterator iterator;
    private long limit = Long.MAX_VALUE;
    private long offset;

    public void init(long limit, long offset) {
        this.limit = limit;
        this.offset = offset;
    }

    @Override
    public ResultIterator<Row> iterator() {
        if (this.iterator != null) {
            throw new IllegalStateException("Iterator can be requested only once");
        }
        this.iterator = new InternalIterator();
        return this.iterator;
    }

    @Override
    public void onError(QueryException error) {
        assert (error != null);
        this.done.compareAndSet(null, error);
    }

    public void done() {
        this.done.compareAndSet(null, NORMAL_COMPLETION);
    }

    public void consume(Inbox inbox) {
        Object[] row;
        this.ensureNotDone();
        while (this.offset > 0L && inbox.poll() != null) {
            --this.offset;
        }
        while ((row = (Object[])inbox.peek()) != null && this.rows.offer(new HeapRow(row))) {
            inbox.remove();
            if (this.limit == Long.MAX_VALUE) continue;
            --this.limit;
            if (this.limit >= 1L) continue;
            this.done.compareAndSet(null, new ResultLimitReachedException());
            this.ensureNotDone();
        }
    }

    public void ensureNotDone() {
        Exception exception = this.done.get();
        if (exception != null) {
            throw ExceptionUtil.sneakyThrow(exception);
        }
    }

    private static class ResultLimitReachedException
    extends Exception {
        ResultLimitReachedException() {
            super("Done by reaching the item number in SQL LIMIT clause", null, false, false);
        }
    }

    private static final class NormalCompletionException
    extends Exception {
        NormalCompletionException() {
            super("Done normally", null, false, false);
        }
    }

    private class InternalIterator
    implements ResultIterator<Row> {
        private final IdleStrategy idler = new BackoffIdleStrategy(0L, 0L, TimeUnit.MICROSECONDS.toNanos(50L), TimeUnit.MILLISECONDS.toNanos(1L));
        private Row nextRow;

        private InternalIterator() {
        }

        @Override
        public ResultIterator.HasNextResult hasNext(long timeout, TimeUnit timeUnit) {
            return this.nextRow != null || (this.nextRow = (Row)JetQueryResultProducer.this.rows.poll()) != null ? ResultIterator.HasNextResult.YES : (this.isDone() ? ResultIterator.HasNextResult.DONE : (timeout == 0L ? ResultIterator.HasNextResult.TIMEOUT : this.hasNextWait(System.nanoTime() + timeUnit.toNanos(timeout))));
        }

        @Override
        public boolean hasNext() {
            return this.hasNextWait(Long.MAX_VALUE) == ResultIterator.HasNextResult.YES;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Row row = this.nextRow;
                return row;
            }
            finally {
                this.nextRow = (Row)JetQueryResultProducer.this.rows.poll();
            }
        }

        private ResultIterator.HasNextResult hasNextWait(long endTimeNanos) {
            long idleCount = 0L;
            do {
                if (this.nextRow != null || (this.nextRow = (Row)JetQueryResultProducer.this.rows.poll()) != null) {
                    return ResultIterator.HasNextResult.YES;
                }
                if (this.isDone()) {
                    return ResultIterator.HasNextResult.DONE;
                }
                this.idler.idle(++idleCount);
            } while (System.nanoTime() < endTimeNanos);
            return ResultIterator.HasNextResult.TIMEOUT;
        }

        private boolean isDone() {
            Exception exception = (Exception)JetQueryResultProducer.this.done.get();
            if (exception != null) {
                if (exception instanceof NormalCompletionException || exception instanceof ResultLimitReachedException) {
                    return JetQueryResultProducer.this.rows.isEmpty();
                }
                throw ExceptionUtil.sneakyThrow(exception);
            }
            return false;
        }
    }
}

