/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.jet.sql.impl.JetPlan;
import com.hazelcast.jet.sql.impl.JetPlanExecutor;
import com.hazelcast.jet.sql.impl.JetSqlToRelConverter;
import com.hazelcast.jet.sql.impl.calcite.parser.JetSqlParser;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRules;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.DeleteByKeyMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JetRootRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRules;
import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.jet.sql.impl.parse.SqlCreateSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlDropJob;
import com.hazelcast.jet.sql.impl.parse.SqlDropMapping;
import com.hazelcast.jet.sql.impl.parse.SqlDropSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.validate.JetSqlValidator;
import com.hazelcast.jet.sql.impl.validate.UnsupportedOperationVisitor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelShuttleImpl;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserImplFactory;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlConformance;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql2rel.SqlRexConvertletTable;
import com.hazelcast.org.apache.calcite.sql2rel.SqlToRelConverter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.calcite.OptimizerContext;
import com.hazelcast.sql.impl.calcite.SqlBackend;
import com.hazelcast.sql.impl.calcite.parse.QueryConvertResult;
import com.hazelcast.sql.impl.calcite.parse.QueryParseResult;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.optimizer.OptimizationTask;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class JetSqlBackend
implements SqlBackend {
    private final NodeEngine nodeEngine;
    private final JetPlanExecutor planExecutor;
    private final ILogger logger;

    public JetSqlBackend(NodeEngine nodeEngine, JetPlanExecutor planExecutor) {
        this.nodeEngine = nodeEngine;
        this.planExecutor = planExecutor;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    @Override
    public SqlParserImplFactory parserFactory() {
        return JetSqlParser.FACTORY;
    }

    @Override
    public SqlValidator validator(Prepare.CatalogReader catalogReader, HazelcastTypeFactory typeFactory, SqlConformance sqlConformance, List<Object> arguments) {
        return new JetSqlValidator(catalogReader, typeFactory, sqlConformance, arguments);
    }

    @Override
    public SqlVisitor<Void> unsupportedOperationVisitor(Prepare.CatalogReader catalogReader) {
        return new UnsupportedOperationVisitor();
    }

    @Override
    public SqlToRelConverter converter(RelOptTable.ViewExpander viewExpander, SqlValidator sqlValidator, Prepare.CatalogReader catalogReader, RelOptCluster relOptCluster, SqlRexConvertletTable sqlRexConvertletTable, SqlToRelConverter.Config config) {
        return new JetSqlToRelConverter(viewExpander, sqlValidator, catalogReader, relOptCluster, sqlRexConvertletTable, config);
    }

    @Override
    public SqlPlan createPlan(OptimizationTask task, QueryParseResult parseResult, OptimizerContext context) {
        SqlNode node = parseResult.getNode();
        PlanKey planKey = new PlanKey(task.getSearchPaths(), task.getSql());
        if (node instanceof SqlCreateMapping) {
            return this.toCreateMappingPlan(planKey, (SqlCreateMapping)node);
        }
        if (node instanceof SqlDropMapping) {
            return this.toDropMappingPlan(planKey, (SqlDropMapping)node);
        }
        if (node instanceof SqlCreateJob) {
            return this.toCreateJobPlan(planKey, parseResult, context);
        }
        if (node instanceof SqlAlterJob) {
            return this.toAlterJobPlan(planKey, (SqlAlterJob)node);
        }
        if (node instanceof SqlDropJob) {
            return this.toDropJobPlan(planKey, (SqlDropJob)node);
        }
        if (node instanceof SqlCreateSnapshot) {
            return this.toCreateSnapshotPlan(planKey, (SqlCreateSnapshot)node);
        }
        if (node instanceof SqlDropSnapshot) {
            return this.toDropSnapshotPlan(planKey, (SqlDropSnapshot)node);
        }
        if (node instanceof SqlShowStatement) {
            return this.toShowStatementPlan(planKey, (SqlShowStatement)node);
        }
        QueryConvertResult convertResult = context.convert(parseResult);
        return this.toPlan(planKey, parseResult.getParameterMetadata(), convertResult.getRel(), convertResult.getFieldNames(), context, parseResult.isInfiniteRows());
    }

    private SqlPlan toCreateMappingPlan(PlanKey planKey, SqlCreateMapping sqlCreateMapping) {
        List<MappingField> mappingFields = sqlCreateMapping.columns().map(field -> new MappingField(field.name(), field.type(), field.externalName())).collect(Collectors.toList());
        Mapping mapping = new Mapping(sqlCreateMapping.nameWithoutSchema(), sqlCreateMapping.externalName(), sqlCreateMapping.type(), mappingFields, sqlCreateMapping.options());
        return new JetPlan.CreateMappingPlan(planKey, mapping, sqlCreateMapping.getReplace(), sqlCreateMapping.ifNotExists(), this.planExecutor);
    }

    private SqlPlan toDropMappingPlan(PlanKey planKey, SqlDropMapping sqlDropMapping) {
        return new JetPlan.DropMappingPlan(planKey, sqlDropMapping.nameWithoutSchema(), sqlDropMapping.ifExists(), this.planExecutor);
    }

    private SqlPlan toCreateJobPlan(PlanKey planKey, QueryParseResult parseResult, OptimizerContext context) {
        SqlCreateJob sqlCreateJob = (SqlCreateJob)parseResult.getNode();
        SqlExtendedInsert source = sqlCreateJob.dmlStatement();
        QueryParseResult dmlParseResult = new QueryParseResult(source, parseResult.getParameterMetadata(), parseResult.getValidator(), this, false);
        QueryConvertResult dmlConvertedResult = context.convert(dmlParseResult);
        JetPlan dmlPlan = this.toPlan(null, parseResult.getParameterMetadata(), dmlConvertedResult.getRel(), dmlConvertedResult.getFieldNames(), context, dmlParseResult.isInfiniteRows());
        assert (dmlPlan instanceof JetPlan.DmlPlan && ((JetPlan.DmlPlan)dmlPlan).getOperation() == TableModify.Operation.INSERT);
        return new JetPlan.CreateJobPlan(planKey, sqlCreateJob.jobConfig(), sqlCreateJob.ifNotExists(), (JetPlan.DmlPlan)dmlPlan, this.planExecutor);
    }

    private SqlPlan toAlterJobPlan(PlanKey planKey, SqlAlterJob sqlAlterJob) {
        return new JetPlan.AlterJobPlan(planKey, sqlAlterJob.name(), sqlAlterJob.getOperation(), this.planExecutor);
    }

    private SqlPlan toDropJobPlan(PlanKey planKey, SqlDropJob sqlDropJob) {
        return new JetPlan.DropJobPlan(planKey, sqlDropJob.name(), sqlDropJob.ifExists(), sqlDropJob.withSnapshotName(), this.planExecutor);
    }

    private SqlPlan toCreateSnapshotPlan(PlanKey planKey, SqlCreateSnapshot sqlNode) {
        return new JetPlan.CreateSnapshotPlan(planKey, sqlNode.getSnapshotName(), sqlNode.getJobName(), this.planExecutor);
    }

    private SqlPlan toDropSnapshotPlan(PlanKey planKey, SqlDropSnapshot sqlNode) {
        return new JetPlan.DropSnapshotPlan(planKey, sqlNode.getSnapshotName(), sqlNode.isIfExists(), this.planExecutor);
    }

    private SqlPlan toShowStatementPlan(PlanKey planKey, SqlShowStatement sqlNode) {
        return new JetPlan.ShowStatementPlan(planKey, sqlNode.getTarget(), this.planExecutor);
    }

    private JetPlan toPlan(PlanKey planKey, QueryParameterMetadata parameterMetadata, RelNode rel, List<String> fieldNames, OptimizerContext context, boolean isInfiniteRows) {
        PhysicalRel physicalRel = this.optimize(parameterMetadata, rel, context);
        List<Permission> permissions = this.extractPermissions(physicalRel);
        Address localAddress = this.nodeEngine.getThisAddress();
        if (physicalRel instanceof DeleteByKeyMapPhysicalRel) {
            DeleteByKeyMapPhysicalRel deleteRel = (DeleteByKeyMapPhysicalRel)physicalRel;
            return new JetPlan.IMapDeletePlan(planKey, deleteRel.objectKey(), parameterMetadata, deleteRel.mapName(), deleteRel.keyCondition(parameterMetadata), this.planExecutor, permissions);
        }
        if (physicalRel instanceof TableModify) {
            CreateDagVisitor visitor = this.traverseRel(physicalRel, parameterMetadata);
            TableModify.Operation operation = ((TableModify)((Object)physicalRel)).getOperation();
            return new JetPlan.DmlPlan(operation, planKey, parameterMetadata, visitor.getObjectKeys(), visitor.getDag(), this.planExecutor, permissions);
        }
        CreateDagVisitor visitor = this.traverseRel(new JetRootRel(physicalRel, localAddress), parameterMetadata);
        SqlRowMetadata rowMetadata = this.createRowMetadata(fieldNames, physicalRel.schema(parameterMetadata).getTypes());
        return new JetPlan.SelectPlan(planKey, parameterMetadata, visitor.getObjectKeys(), visitor.getDag(), isInfiniteRows, rowMetadata, this.planExecutor, permissions);
    }

    private List<Permission> extractPermissions(PhysicalRel physicalRel) {
        final ArrayList<Permission> permissions = new ArrayList<Permission>();
        physicalRel.accept(new RelShuttleImpl(){

            @Override
            public RelNode visit(TableScan scan) {
                this.addPermissionForTable(scan.getTable(), "read");
                return super.visit(scan);
            }

            @Override
            public RelNode visit(RelNode other) {
                this.addPermissionForTable(other.getTable(), "put");
                return super.visit(other);
            }

            private void addPermissionForTable(RelOptTable t, String action) {
                if (t == null) {
                    return;
                }
                HazelcastTable table = t.unwrap(HazelcastTable.class);
                if (table != null && table.getTarget() instanceof AbstractMapTable) {
                    String mapName = ((AbstractMapTable)table.getTarget()).getMapName();
                    permissions.add(new MapPermission(mapName, action));
                }
            }
        });
        return permissions;
    }

    private PhysicalRel optimize(QueryParameterMetadata parameterMetadata, RelNode rel, OptimizerContext context) {
        context.setParameterMetadata(parameterMetadata);
        this.logger.fine("Before logical opt:\n" + RelOptUtil.toString(rel));
        LogicalRel logicalRel = this.optimizeLogical(context, rel);
        this.logger.fine("After logical opt:\n" + RelOptUtil.toString(logicalRel));
        PhysicalRel physicalRel = this.optimizePhysical(context, logicalRel);
        this.logger.fine("After physical opt:\n" + RelOptUtil.toString(physicalRel));
        return physicalRel;
    }

    private LogicalRel optimizeLogical(OptimizerContext context, RelNode rel) {
        return (LogicalRel)context.optimize(rel, LogicalRules.getRuleSet(), OptUtils.toLogicalConvention(rel.getTraitSet()));
    }

    private PhysicalRel optimizePhysical(OptimizerContext context, RelNode rel) {
        return (PhysicalRel)context.optimize(rel, PhysicalRules.getRuleSet(), OptUtils.toPhysicalConvention(rel.getTraitSet()));
    }

    private SqlRowMetadata createRowMetadata(List<String> columnNames, List<QueryDataType> columnTypes) {
        assert (columnNames.size() == columnTypes.size());
        ArrayList<SqlColumnMetadata> columns = new ArrayList<SqlColumnMetadata>(columnNames.size());
        for (int i = 0; i < columnNames.size(); ++i) {
            SqlColumnMetadata column = QueryUtils.getColumnMetadata(columnNames.get(i), columnTypes.get(i), true);
            columns.add(column);
        }
        return new SqlRowMetadata(columns);
    }

    private CreateDagVisitor traverseRel(PhysicalRel physicalRel, QueryParameterMetadata parameterMetadata) {
        CreateDagVisitor visitor = new CreateDagVisitor(this.nodeEngine, parameterMetadata);
        physicalRel.accept(visitor);
        return visitor;
    }
}

