/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.JetPlan;
import com.hazelcast.jet.sql.impl.JetPlanExecutor;
import com.hazelcast.jet.sql.impl.JetQueryResultProducer;
import com.hazelcast.jet.sql.impl.JetSqlBackend;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.map.JetMapMetadataResolverImpl;
import com.hazelcast.jet.sql.impl.schema.MappingCatalog;
import com.hazelcast.jet.sql.impl.schema.MappingStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.impl.JetSqlCoreBackend;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.map.JetMapMetadataResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class JetSqlCoreBackendImpl
implements JetSqlCoreBackend,
ManagedService {
    private MappingCatalog catalog;
    private JetSqlBackend sqlBackend;
    private Map<Long, JetQueryResultProducer> resultConsumerRegistry;

    public void init(@Nonnull HazelcastInstance hazelcastInstance) {
        NodeEngineImpl nodeEngine = Util.getNodeEngine(hazelcastInstance);
        MappingStorage mappingStorage = new MappingStorage(nodeEngine);
        SqlConnectorCache connectorCache = new SqlConnectorCache(nodeEngine);
        MappingCatalog mappingCatalog = new MappingCatalog(nodeEngine, mappingStorage, connectorCache);
        this.resultConsumerRegistry = new ConcurrentHashMap<Long, JetQueryResultProducer>();
        JetPlanExecutor planExecutor = new JetPlanExecutor(mappingCatalog, hazelcastInstance, this.resultConsumerRegistry);
        this.catalog = mappingCatalog;
        this.sqlBackend = new JetSqlBackend(nodeEngine, planExecutor);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public List<TableResolver> tableResolvers() {
        return Collections.singletonList(this.catalog);
    }

    @Override
    public JetMapMetadataResolver mapMetadataResolver() {
        return JetMapMetadataResolverImpl.INSTANCE;
    }

    @Override
    public Object sqlBackend() {
        return this.sqlBackend;
    }

    @Override
    public SqlResult execute(QueryId queryId, SqlPlan plan, List<Object> arguments, long timeout, int pageSize) {
        return ((JetPlan)plan).execute(queryId, arguments, timeout);
    }

    public Map<Long, JetQueryResultProducer> getResultConsumerRegistry() {
        return this.resultConsumerRegistry;
    }

    @Override
    public void reset() {
    }

    @Override
    public void shutdown(boolean terminate) {
    }
}

